// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the resources available for a container instance.
 */
public class Resource private constructor(builder: Builder) {
    /**
     * When the `doubleValue` type is set, the value of the resource must be a double precision floating-point type.
     */
    public val doubleValue: kotlin.Double = builder.doubleValue
    /**
     * When the `integerValue` type is set, the value of the resource must be an integer.
     */
    public val integerValue: kotlin.Int = builder.integerValue
    /**
     * When the `longValue` type is set, the value of the resource must be an extended precision floating-point type.
     */
    public val longValue: kotlin.Long = builder.longValue
    /**
     * The name of the resource, such as `CPU`, `MEMORY`, `PORTS`, `PORTS_UDP`, or a user-defined resource.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When the `stringSetValue` type is set, the value of the resource must be a string type.
     */
    public val stringSetValue: List<String>? = builder.stringSetValue
    /**
     * The type of the resource. Valid values: `INTEGER`, `DOUBLE`, `LONG`, or `STRINGSET`.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Resource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Resource(")
        append("doubleValue=$doubleValue,")
        append("integerValue=$integerValue,")
        append("longValue=$longValue,")
        append("name=$name,")
        append("stringSetValue=$stringSetValue,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = doubleValue.hashCode()
        result = 31 * result + (integerValue)
        result = 31 * result + (longValue.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stringSetValue?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Resource

        if (!(doubleValue?.equals(other.doubleValue) ?: (other.doubleValue == null))) return false
        if (integerValue != other.integerValue) return false
        if (longValue != other.longValue) return false
        if (name != other.name) return false
        if (stringSetValue != other.stringSetValue) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Resource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the `doubleValue` type is set, the value of the resource must be a double precision floating-point type.
         */
        public var doubleValue: kotlin.Double = 0.0
        /**
         * When the `integerValue` type is set, the value of the resource must be an integer.
         */
        public var integerValue: kotlin.Int = 0
        /**
         * When the `longValue` type is set, the value of the resource must be an extended precision floating-point type.
         */
        public var longValue: kotlin.Long = 0L
        /**
         * The name of the resource, such as `CPU`, `MEMORY`, `PORTS`, `PORTS_UDP`, or a user-defined resource.
         */
        public var name: kotlin.String? = null
        /**
         * When the `stringSetValue` type is set, the value of the resource must be a string type.
         */
        public var stringSetValue: List<String>? = null
        /**
         * The type of the resource. Valid values: `INTEGER`, `DOUBLE`, `LONG`, or `STRINGSET`.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Resource) : this() {
            this.doubleValue = x.doubleValue
            this.integerValue = x.integerValue
            this.longValue = x.longValue
            this.name = x.name
            this.stringSetValue = x.stringSetValue
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Resource = Resource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
