// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RegisterContainerInstanceRequest private constructor(builder: Builder) {
    /**
     * The container instance attributes that this container instance supports.
     */
    public val attributes: List<Attribute>? = builder.attributes
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster to register your container instance with. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The ARN of the container instance (if it was previously registered).
     */
    public val containerInstanceArn: kotlin.String? = builder.containerInstanceArn
    /**
     * The instance identity document for the EC2 instance to register. This document can be found by running the following command from the instance: `curl http://169.254.169.254/latest/dynamic/instance-identity/document/`
     */
    public val instanceIdentityDocument: kotlin.String? = builder.instanceIdentityDocument
    /**
     * The instance identity document signature for the EC2 instance to register. This signature can be found by running the following command from the instance: `curl http://169.254.169.254/latest/dynamic/instance-identity/signature/`
     */
    public val instanceIdentityDocumentSignature: kotlin.String? = builder.instanceIdentityDocumentSignature
    /**
     * The devices that are available on the container instance. The only supported device type is a GPU.
     */
    public val platformDevices: List<PlatformDevice>? = builder.platformDevices
    /**
     * The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The resources available on the instance.
     */
    public val totalResources: List<Resource>? = builder.totalResources
    /**
     * The version information for the Amazon ECS container agent and Docker daemon that runs on the container instance.
     */
    public val versionInfo: aws.sdk.kotlin.services.ecs.model.VersionInfo? = builder.versionInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.RegisterContainerInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterContainerInstanceRequest(")
        append("attributes=$attributes,")
        append("cluster=$cluster,")
        append("containerInstanceArn=$containerInstanceArn,")
        append("instanceIdentityDocument=$instanceIdentityDocument,")
        append("instanceIdentityDocumentSignature=$instanceIdentityDocumentSignature,")
        append("platformDevices=$platformDevices,")
        append("tags=$tags,")
        append("totalResources=$totalResources,")
        append("versionInfo=$versionInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (containerInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (instanceIdentityDocument?.hashCode() ?: 0)
        result = 31 * result + (instanceIdentityDocumentSignature?.hashCode() ?: 0)
        result = 31 * result + (platformDevices?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalResources?.hashCode() ?: 0)
        result = 31 * result + (versionInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterContainerInstanceRequest

        if (attributes != other.attributes) return false
        if (cluster != other.cluster) return false
        if (containerInstanceArn != other.containerInstanceArn) return false
        if (instanceIdentityDocument != other.instanceIdentityDocument) return false
        if (instanceIdentityDocumentSignature != other.instanceIdentityDocumentSignature) return false
        if (platformDevices != other.platformDevices) return false
        if (tags != other.tags) return false
        if (totalResources != other.totalResources) return false
        if (versionInfo != other.versionInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.RegisterContainerInstanceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The container instance attributes that this container instance supports.
         */
        public var attributes: List<Attribute>? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster to register your container instance with. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * The ARN of the container instance (if it was previously registered).
         */
        public var containerInstanceArn: kotlin.String? = null
        /**
         * The instance identity document for the EC2 instance to register. This document can be found by running the following command from the instance: `curl http://169.254.169.254/latest/dynamic/instance-identity/document/`
         */
        public var instanceIdentityDocument: kotlin.String? = null
        /**
         * The instance identity document signature for the EC2 instance to register. This signature can be found by running the following command from the instance: `curl http://169.254.169.254/latest/dynamic/instance-identity/signature/`
         */
        public var instanceIdentityDocumentSignature: kotlin.String? = null
        /**
         * The devices that are available on the container instance. The only supported device type is a GPU.
         */
        public var platformDevices: List<PlatformDevice>? = null
        /**
         * The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The resources available on the instance.
         */
        public var totalResources: List<Resource>? = null
        /**
         * The version information for the Amazon ECS container agent and Docker daemon that runs on the container instance.
         */
        public var versionInfo: aws.sdk.kotlin.services.ecs.model.VersionInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.RegisterContainerInstanceRequest) : this() {
            this.attributes = x.attributes
            this.cluster = x.cluster
            this.containerInstanceArn = x.containerInstanceArn
            this.instanceIdentityDocument = x.instanceIdentityDocument
            this.instanceIdentityDocumentSignature = x.instanceIdentityDocumentSignature
            this.platformDevices = x.platformDevices
            this.tags = x.tags
            this.totalResources = x.totalResources
            this.versionInfo = x.versionInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.RegisterContainerInstanceRequest = RegisterContainerInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.VersionInfo] inside the given [block]
         */
        public fun versionInfo(block: aws.sdk.kotlin.services.ecs.model.VersionInfo.Builder.() -> kotlin.Unit) {
            this.versionInfo = aws.sdk.kotlin.services.ecs.model.VersionInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
