// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The log configuration for the container. This parameter maps to `LogConfig` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--log-driver` option to `docker run`[](https://docs.docker.com/engine/reference/commandline/run/).
 *
 * By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition. For more information about the options for different supported log drivers, see [Configure logging drivers](https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
 *
 * Understand the following when specifying a log configuration for your containers.
 * + Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.For tasks on Fargate, the supported log drivers are `awslogs`, `splunk`, and `awsfirelens`.For tasks hosted on Amazon EC2 instances, the supported log drivers are `awslogs`, `fluentd`, `gelf`, `json-file`, `journald`, `logentries`,`syslog`, `splunk`, and `awsfirelens`.
 * + This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
 * + For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the `ECS_AVAILABLE_LOGGING_DRIVERS` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
 * + For tasks that are on Fargate, because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.
 */
public class LogConfiguration private constructor(builder: Builder) {
    /**
     * The log driver to use for the container.
     *
     * For tasks on Fargate, the supported log drivers are `awslogs`, `splunk`, and `awsfirelens`.
     *
     * For tasks hosted on Amazon EC2 instances, the supported log drivers are `awslogs`, `fluentd`, `gelf`, `json-file`, `journald`, `logentries`,`syslog`, `splunk`, and `awsfirelens`.
     *
     * For more information about using the `awslogs` log driver, see [Using the awslogs log driver](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For more information about using the `awsfirelens` log driver, see [Custom log routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's [available on GitHub](https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
     */
    public val logDriver: aws.sdk.kotlin.services.ecs.model.LogDriver = requireNotNull(builder.logDriver) { "A non-null value must be provided for logDriver" }
    /**
     * The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
     */
    public val options: Map<String, String>? = builder.options
    /**
     * The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val secretOptions: List<Secret>? = builder.secretOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.LogConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogConfiguration(")
        append("logDriver=$logDriver,")
        append("options=$options,")
        append("secretOptions=$secretOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logDriver.hashCode()
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (secretOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogConfiguration

        if (logDriver != other.logDriver) return false
        if (options != other.options) return false
        if (secretOptions != other.secretOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.LogConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The log driver to use for the container.
         *
         * For tasks on Fargate, the supported log drivers are `awslogs`, `splunk`, and `awsfirelens`.
         *
         * For tasks hosted on Amazon EC2 instances, the supported log drivers are `awslogs`, `fluentd`, `gelf`, `json-file`, `journald`, `logentries`,`syslog`, `splunk`, and `awsfirelens`.
         *
         * For more information about using the `awslogs` log driver, see [Using the awslogs log driver](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * For more information about using the `awsfirelens` log driver, see [Custom log routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's [available on GitHub](https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
         */
        public var logDriver: aws.sdk.kotlin.services.ecs.model.LogDriver? = null
        /**
         * The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: `sudo docker version --format '{{.Server.APIVersion}}'`
         */
        public var options: Map<String, String>? = null
        /**
         * The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var secretOptions: List<Secret>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.LogConfiguration) : this() {
            this.logDriver = x.logDriver
            this.options = x.options
            this.secretOptions = x.secretOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.LogConfiguration = LogConfiguration(this)

        internal fun correctErrors(): Builder {
            if (logDriver == null) logDriver = LogDriver.SdkUnknown("no value provided")
            return this
        }
    }
}
