// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListTasksRequest private constructor(builder: Builder) {
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the `ListTasks` results. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The container instance ID or full ARN of the container instance to use when filtering the `ListTasks` results. Specifying a `containerInstance` limits the results to tasks that belong to that container instance.
     */
    public val containerInstance: kotlin.String? = builder.containerInstance
    /**
     * The task desired status to use when filtering the `ListTasks` results. Specifying a `desiredStatus` of `STOPPED` limits the results to tasks that Amazon ECS has set the desired status to `STOPPED`. This can be useful for debugging tasks that aren't starting properly or have died or finished. The default status filter is `RUNNING`, which shows tasks that Amazon ECS has set the desired status to `RUNNING`.
     *
     * Although you can filter results based on a desired status of `PENDING`, this doesn't return any results. Amazon ECS never sets the desired status of a task to that value (only a task's `lastStatus` may have a value of `PENDING`).
     */
    public val desiredStatus: aws.sdk.kotlin.services.ecs.model.DesiredStatus? = builder.desiredStatus
    /**
     * The name of the task definition family to use when filtering the `ListTasks` results. Specifying a `family` limits the results to tasks that belong to that family.
     */
    public val family: kotlin.String? = builder.family
    /**
     * The launch type to use when filtering the `ListTasks` results.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * The maximum number of task results that `ListTasks` returned in paginated output. When this parameter is used, `ListTasks` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListTasks` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListTasks` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a `ListTasks` request indicating that more results are available to fulfill the request and further calls will be needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the service to use when filtering the `ListTasks` results. Specifying a `serviceName` limits the results to tasks that belong to that service.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The `startedBy` value to filter the task results with. Specifying a `startedBy` value limits the results to tasks that were started with that value.
     *
     * When you specify `startedBy` as the filter, it must be the only filter that you use.
     */
    public val startedBy: kotlin.String? = builder.startedBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ListTasksRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTasksRequest(")
        append("cluster=$cluster,")
        append("containerInstance=$containerInstance,")
        append("desiredStatus=$desiredStatus,")
        append("family=$family,")
        append("launchType=$launchType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("serviceName=$serviceName,")
        append("startedBy=$startedBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cluster?.hashCode() ?: 0
        result = 31 * result + (containerInstance?.hashCode() ?: 0)
        result = 31 * result + (desiredStatus?.hashCode() ?: 0)
        result = 31 * result + (family?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTasksRequest

        if (cluster != other.cluster) return false
        if (containerInstance != other.containerInstance) return false
        if (desiredStatus != other.desiredStatus) return false
        if (family != other.family) return false
        if (launchType != other.launchType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (serviceName != other.serviceName) return false
        if (startedBy != other.startedBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ListTasksRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the `ListTasks` results. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * The container instance ID or full ARN of the container instance to use when filtering the `ListTasks` results. Specifying a `containerInstance` limits the results to tasks that belong to that container instance.
         */
        public var containerInstance: kotlin.String? = null
        /**
         * The task desired status to use when filtering the `ListTasks` results. Specifying a `desiredStatus` of `STOPPED` limits the results to tasks that Amazon ECS has set the desired status to `STOPPED`. This can be useful for debugging tasks that aren't starting properly or have died or finished. The default status filter is `RUNNING`, which shows tasks that Amazon ECS has set the desired status to `RUNNING`.
         *
         * Although you can filter results based on a desired status of `PENDING`, this doesn't return any results. Amazon ECS never sets the desired status of a task to that value (only a task's `lastStatus` may have a value of `PENDING`).
         */
        public var desiredStatus: aws.sdk.kotlin.services.ecs.model.DesiredStatus? = null
        /**
         * The name of the task definition family to use when filtering the `ListTasks` results. Specifying a `family` limits the results to tasks that belong to that family.
         */
        public var family: kotlin.String? = null
        /**
         * The launch type to use when filtering the `ListTasks` results.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * The maximum number of task results that `ListTasks` returned in paginated output. When this parameter is used, `ListTasks` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListTasks` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListTasks` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a `ListTasks` request indicating that more results are available to fulfill the request and further calls will be needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the service to use when filtering the `ListTasks` results. Specifying a `serviceName` limits the results to tasks that belong to that service.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The `startedBy` value to filter the task results with. Specifying a `startedBy` value limits the results to tasks that were started with that value.
         *
         * When you specify `startedBy` as the filter, it must be the only filter that you use.
         */
        public var startedBy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ListTasksRequest) : this() {
            this.cluster = x.cluster
            this.containerInstance = x.containerInstance
            this.desiredStatus = x.desiredStatus
            this.family = x.family
            this.launchType = x.launchType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.serviceName = x.serviceName
            this.startedBy = x.startedBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ListTasksRequest = ListTasksRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
