// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon ECS Developer Guide;*.
 *
 * For tasks using the Fargate launch type, the task requires the following platforms:
 * + Linux platform version `1.4.0` or later.
 * + Windows platform version `1.0.0` or later.
 */
public class EphemeralStorage private constructor(builder: Builder) {
    /**
     * The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `20` GiB and the maximum supported value is `200` GiB.
     */
    public val sizeInGib: kotlin.Int = builder.sizeInGib

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.EphemeralStorage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EphemeralStorage(")
        append("sizeInGib=$sizeInGib")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sizeInGib
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EphemeralStorage

        if (sizeInGib != other.sizeInGib) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.EphemeralStorage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is `20` GiB and the maximum supported value is `200` GiB.
         */
        public var sizeInGib: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.EphemeralStorage) : this() {
            this.sizeInGib = x.sizeInGib
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.EphemeralStorage = EphemeralStorage(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
