// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of files containing the environment variables to pass to a container. You can specify up to ten environment files. The file must have a `.env` file extension. Each line in an environment file should contain an environment variable in `VARIABLE=VALUE` format. Lines beginning with `#` are treated as comments and are ignored.
 *
 * If there are environment variables specified using the `environment` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Use a file to pass environment variables to a container](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/use-environment-file.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * Environment variable files are objects in Amazon S3 and all Amazon S3 security considerations apply.
 *
 * You must use the following platforms for the Fargate launch type:
 * + Linux platform version `1.4.0` or later.
 * + Windows platform version `1.0.0` or later.
 *
 * Consider the following when using the Fargate launch type:
 * + The file is handled like a native Docker env-file.
 * + There is no support for shell escape handling.
 * + The container entry point interperts the `VARIABLE` values.
 */
public class EnvironmentFile private constructor(builder: Builder) {
    /**
     * The file type to use. Environment files are objects in Amazon S3. The only supported value is `s3`.
     */
    public val type: aws.sdk.kotlin.services.ecs.model.EnvironmentFileType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.EnvironmentFile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentFile(")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentFile

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.EnvironmentFile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The file type to use. Environment files are objects in Amazon S3. The only supported value is `s3`.
         */
        public var type: aws.sdk.kotlin.services.ecs.model.EnvironmentFileType? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.EnvironmentFile) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.EnvironmentFile = EnvironmentFile(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = EnvironmentFileType.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
