// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that represents a change in state for a container.
 */
public class ContainerStateChange private constructor(builder: Builder) {
    /**
     * The name of the container.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * The exit code for the container, if the state change is a result of the container exiting.
     */
    public val exitCode: kotlin.Int? = builder.exitCode
    /**
     * The container image SHA 256 digest.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * Any network bindings that are associated with the container.
     */
    public val networkBindings: List<NetworkBinding>? = builder.networkBindings
    /**
     * The reason for the state change.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The ID of the Docker container.
     */
    public val runtimeId: kotlin.String? = builder.runtimeId
    /**
     * The status of the container.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ContainerStateChange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerStateChange(")
        append("containerName=$containerName,")
        append("exitCode=$exitCode,")
        append("imageDigest=$imageDigest,")
        append("networkBindings=$networkBindings,")
        append("reason=$reason,")
        append("runtimeId=$runtimeId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (exitCode ?: 0)
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (networkBindings?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (runtimeId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerStateChange

        if (containerName != other.containerName) return false
        if (exitCode != other.exitCode) return false
        if (imageDigest != other.imageDigest) return false
        if (networkBindings != other.networkBindings) return false
        if (reason != other.reason) return false
        if (runtimeId != other.runtimeId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ContainerStateChange = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the container.
         */
        public var containerName: kotlin.String? = null
        /**
         * The exit code for the container, if the state change is a result of the container exiting.
         */
        public var exitCode: kotlin.Int? = null
        /**
         * The container image SHA 256 digest.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * Any network bindings that are associated with the container.
         */
        public var networkBindings: List<NetworkBinding>? = null
        /**
         * The reason for the state change.
         */
        public var reason: kotlin.String? = null
        /**
         * The ID of the Docker container.
         */
        public var runtimeId: kotlin.String? = null
        /**
         * The status of the container.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ContainerStateChange) : this() {
            this.containerName = x.containerName
            this.exitCode = x.exitCode
            this.imageDigest = x.imageDigest
            this.networkBindings = x.networkBindings
            this.reason = x.reason
            this.runtimeId = x.runtimeId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ContainerStateChange = ContainerStateChange(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
