// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The dependencies defined for container startup and shutdown. A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
 *
 * Your Amazon ECS container instances require at least version 1.26.0 of the container agent to use container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the `ecs-init` package. If your container instances are launched from version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * For tasks that use the Fargate launch type, the task or service requires the following platforms:
 * + Linux platform version `1.3.0` or later.
 * + Windows platform version `1.0.0` or later.
 * For more information about how to create a container dependency, see [Container dependency](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/example_task_definitions.html#example_task_definition-containerdependency) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class ContainerDependency private constructor(builder: Builder) {
    /**
     * The dependency condition of the container. The following are the available conditions and their behavior:
     * + `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
     * + `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
     * + `SUCCESS` - This condition is the same as `COMPLETE`, but it also requires that the container exits with a `zero` status. This condition can't be set on an essential container.
     * + `HEALTHY` - This condition validates that the dependent container passes its Docker health check before permitting other containers to start. This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.
     */
    public val condition: aws.sdk.kotlin.services.ecs.model.ContainerCondition = requireNotNull(builder.condition) { "A non-null value must be provided for condition" }
    /**
     * The name of a container.
     */
    public val containerName: kotlin.String = requireNotNull(builder.containerName) { "A non-null value must be provided for containerName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ContainerDependency = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDependency(")
        append("condition=$condition,")
        append("containerName=$containerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition.hashCode()
        result = 31 * result + (containerName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDependency

        if (condition != other.condition) return false
        if (containerName != other.containerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ContainerDependency = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The dependency condition of the container. The following are the available conditions and their behavior:
         * + `START` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
         * + `COMPLETE` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
         * + `SUCCESS` - This condition is the same as `COMPLETE`, but it also requires that the container exits with a `zero` status. This condition can't be set on an essential container.
         * + `HEALTHY` - This condition validates that the dependent container passes its Docker health check before permitting other containers to start. This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.
         */
        public var condition: aws.sdk.kotlin.services.ecs.model.ContainerCondition? = null
        /**
         * The name of a container.
         */
        public var containerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ContainerDependency) : this() {
            this.condition = x.condition
            this.containerName = x.containerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ContainerDependency = ContainerDependency(this)

        internal fun correctErrors(): Builder {
            if (condition == null) condition = ContainerCondition.SdkUnknown("no value provided")
            if (containerName == null) containerName = ""
            return this
        }
    }
}
