// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A Docker container that's part of a task.
 */
public class Container private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the container.
     */
    public val containerArn: kotlin.String? = builder.containerArn
    /**
     * The number of CPU units set for the container. The value is `0` if no value was specified in the container definition when the task definition was registered.
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The exit code returned from the container.
     */
    public val exitCode: kotlin.Int? = builder.exitCode
    /**
     * The IDs of each GPU assigned to the container.
     */
    public val gpuIds: List<String>? = builder.gpuIds
    /**
     * The health status of the container. If health checks aren't configured for this container in its task definition, then it reports the health status as `UNKNOWN`.
     */
    public val healthStatus: aws.sdk.kotlin.services.ecs.model.HealthStatus? = builder.healthStatus
    /**
     * The image used for the container.
     */
    public val image: kotlin.String? = builder.image
    /**
     * The container image manifest digest.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The last known status of the container.
     */
    public val lastStatus: kotlin.String? = builder.lastStatus
    /**
     * The details of any Amazon ECS managed agents associated with the container.
     */
    public val managedAgents: List<ManagedAgent>? = builder.managedAgents
    /**
     * The hard limit (in MiB) of memory set for the container.
     */
    public val memory: kotlin.String? = builder.memory
    /**
     * The soft limit (in MiB) of memory set for the container.
     */
    public val memoryReservation: kotlin.String? = builder.memoryReservation
    /**
     * The name of the container.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network bindings associated with the container.
     */
    public val networkBindings: List<NetworkBinding>? = builder.networkBindings
    /**
     * The network interfaces associated with the container.
     */
    public val networkInterfaces: List<NetworkInterface>? = builder.networkInterfaces
    /**
     * A short (255 max characters) human-readable string to provide additional details about a running or stopped container.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The ID of the Docker container.
     */
    public val runtimeId: kotlin.String? = builder.runtimeId
    /**
     * The ARN of the task.
     */
    public val taskArn: kotlin.String? = builder.taskArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Container = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Container(")
        append("containerArn=$containerArn,")
        append("cpu=$cpu,")
        append("exitCode=$exitCode,")
        append("gpuIds=$gpuIds,")
        append("healthStatus=$healthStatus,")
        append("image=$image,")
        append("imageDigest=$imageDigest,")
        append("lastStatus=$lastStatus,")
        append("managedAgents=$managedAgents,")
        append("memory=$memory,")
        append("memoryReservation=$memoryReservation,")
        append("name=$name,")
        append("networkBindings=$networkBindings,")
        append("networkInterfaces=$networkInterfaces,")
        append("reason=$reason,")
        append("runtimeId=$runtimeId,")
        append("taskArn=$taskArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerArn?.hashCode() ?: 0
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (exitCode ?: 0)
        result = 31 * result + (gpuIds?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (lastStatus?.hashCode() ?: 0)
        result = 31 * result + (managedAgents?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (memoryReservation?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkBindings?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (runtimeId?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Container

        if (containerArn != other.containerArn) return false
        if (cpu != other.cpu) return false
        if (exitCode != other.exitCode) return false
        if (gpuIds != other.gpuIds) return false
        if (healthStatus != other.healthStatus) return false
        if (image != other.image) return false
        if (imageDigest != other.imageDigest) return false
        if (lastStatus != other.lastStatus) return false
        if (managedAgents != other.managedAgents) return false
        if (memory != other.memory) return false
        if (memoryReservation != other.memoryReservation) return false
        if (name != other.name) return false
        if (networkBindings != other.networkBindings) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (reason != other.reason) return false
        if (runtimeId != other.runtimeId) return false
        if (taskArn != other.taskArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Container = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the container.
         */
        public var containerArn: kotlin.String? = null
        /**
         * The number of CPU units set for the container. The value is `0` if no value was specified in the container definition when the task definition was registered.
         */
        public var cpu: kotlin.String? = null
        /**
         * The exit code returned from the container.
         */
        public var exitCode: kotlin.Int? = null
        /**
         * The IDs of each GPU assigned to the container.
         */
        public var gpuIds: List<String>? = null
        /**
         * The health status of the container. If health checks aren't configured for this container in its task definition, then it reports the health status as `UNKNOWN`.
         */
        public var healthStatus: aws.sdk.kotlin.services.ecs.model.HealthStatus? = null
        /**
         * The image used for the container.
         */
        public var image: kotlin.String? = null
        /**
         * The container image manifest digest.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The last known status of the container.
         */
        public var lastStatus: kotlin.String? = null
        /**
         * The details of any Amazon ECS managed agents associated with the container.
         */
        public var managedAgents: List<ManagedAgent>? = null
        /**
         * The hard limit (in MiB) of memory set for the container.
         */
        public var memory: kotlin.String? = null
        /**
         * The soft limit (in MiB) of memory set for the container.
         */
        public var memoryReservation: kotlin.String? = null
        /**
         * The name of the container.
         */
        public var name: kotlin.String? = null
        /**
         * The network bindings associated with the container.
         */
        public var networkBindings: List<NetworkBinding>? = null
        /**
         * The network interfaces associated with the container.
         */
        public var networkInterfaces: List<NetworkInterface>? = null
        /**
         * A short (255 max characters) human-readable string to provide additional details about a running or stopped container.
         */
        public var reason: kotlin.String? = null
        /**
         * The ID of the Docker container.
         */
        public var runtimeId: kotlin.String? = null
        /**
         * The ARN of the task.
         */
        public var taskArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Container) : this() {
            this.containerArn = x.containerArn
            this.cpu = x.cpu
            this.exitCode = x.exitCode
            this.gpuIds = x.gpuIds
            this.healthStatus = x.healthStatus
            this.image = x.image
            this.imageDigest = x.imageDigest
            this.lastStatus = x.lastStatus
            this.managedAgents = x.managedAgents
            this.memory = x.memory
            this.memoryReservation = x.memoryReservation
            this.name = x.name
            this.networkBindings = x.networkBindings
            this.networkInterfaces = x.networkInterfaces
            this.reason = x.reason
            this.runtimeId = x.runtimeId
            this.taskArn = x.taskArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Container = Container(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
