// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.AttachmentStateChange
import aws.sdk.kotlin.services.ecs.model.ContainerStateChange
import aws.sdk.kotlin.services.ecs.model.ManagedAgentStateChange
import aws.sdk.kotlin.services.ecs.model.SubmitTaskStateChangeRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class SubmitTaskStateChangeOperationSerializer: HttpSerializer.NonStreaming<SubmitTaskStateChangeRequest> {
    override fun serialize(context: ExecutionContext, input: SubmitTaskStateChangeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeSubmitTaskStateChangeOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeSubmitTaskStateChangeOperationBody(context: ExecutionContext, input: SubmitTaskStateChangeRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTACHMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("attachments"))
    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cluster"))
    val CONTAINERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("containers"))
    val EXECUTIONSTOPPEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("executionStoppedAt"))
    val MANAGEDAGENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("managedAgents"))
    val PULLSTARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("pullStartedAt"))
    val PULLSTOPPEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("pullStoppedAt"))
    val REASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reason"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TASK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("task"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHMENTS_DESCRIPTOR)
        field(CLUSTER_DESCRIPTOR)
        field(CONTAINERS_DESCRIPTOR)
        field(EXECUTIONSTOPPEDAT_DESCRIPTOR)
        field(MANAGEDAGENTS_DESCRIPTOR)
        field(PULLSTARTEDAT_DESCRIPTOR)
        field(PULLSTOPPEDAT_DESCRIPTOR)
        field(REASON_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASK_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attachments != null) {
            listField(ATTACHMENTS_DESCRIPTOR) {
                for (el0 in input.attachments) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAttachmentStateChangeDocument))
                }
            }
        }
        input.cluster?.let { field(CLUSTER_DESCRIPTOR, it) }
        if (input.containers != null) {
            listField(CONTAINERS_DESCRIPTOR) {
                for (el0 in input.containers) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeContainerStateChangeDocument))
                }
            }
        }
        input.executionStoppedAt?.let { field(EXECUTIONSTOPPEDAT_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        if (input.managedAgents != null) {
            listField(MANAGEDAGENTS_DESCRIPTOR) {
                for (el0 in input.managedAgents) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeManagedAgentStateChangeDocument))
                }
            }
        }
        input.pullStartedAt?.let { field(PULLSTARTEDAT_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.pullStoppedAt?.let { field(PULLSTOPPEDAT_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.reason?.let { field(REASON_DESCRIPTOR, it) }
        input.status?.let { field(STATUS_DESCRIPTOR, it) }
        input.task?.let { field(TASK_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
