// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.DescribeServicesResponse
import aws.sdk.kotlin.services.ecs.model.EcsException
import aws.sdk.kotlin.services.ecs.model.Failure
import aws.sdk.kotlin.services.ecs.model.Service
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeServicesOperationDeserializer: HttpDeserializer.NonStreaming<DescribeServicesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeServicesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeServicesError(context, call, payload)
        }
        val builder = DescribeServicesResponse.Builder()

        if (payload != null) {
            deserializeDescribeServicesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeServicesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterNotFoundException" -> ClusterNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EcsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeServicesOperationBody(builder: DescribeServicesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failures"))
    val SERVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("services"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILURES_DESCRIPTOR)
        field(SERVICES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILURES_DESCRIPTOR.index -> builder.failures =
                    deserializer.deserializeList(FAILURES_DESCRIPTOR) {
                        val col0 = mutableListOf<Failure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SERVICES_DESCRIPTOR.index -> builder.services =
                    deserializer.deserializeList(SERVICES_DESCRIPTOR) {
                        val col0 = mutableListOf<Service>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServiceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
