// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Docker and Amazon ECS container agent version information about a container instance.
 */
public class VersionInfo private constructor(builder: Builder) {
    /**
     * The Git commit hash for the Amazon ECS container agent build on the [amazon-ecs-agent ](https://github.com/aws/amazon-ecs-agent/commits/master) GitHub repository.
     */
    public val agentHash: kotlin.String? = builder.agentHash
    /**
     * The version number of the Amazon ECS container agent.
     */
    public val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * The Docker version that's running on the container instance.
     */
    public val dockerVersion: kotlin.String? = builder.dockerVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.VersionInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VersionInfo(")
        append("agentHash=$agentHash,")
        append("agentVersion=$agentVersion,")
        append("dockerVersion=$dockerVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentHash?.hashCode() ?: 0
        result = 31 * result + (agentVersion?.hashCode() ?: 0)
        result = 31 * result + (dockerVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VersionInfo

        if (agentHash != other.agentHash) return false
        if (agentVersion != other.agentVersion) return false
        if (dockerVersion != other.dockerVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.VersionInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Git commit hash for the Amazon ECS container agent build on the [amazon-ecs-agent ](https://github.com/aws/amazon-ecs-agent/commits/master) GitHub repository.
         */
        public var agentHash: kotlin.String? = null
        /**
         * The version number of the Amazon ECS container agent.
         */
        public var agentVersion: kotlin.String? = null
        /**
         * The Docker version that's running on the container instance.
         */
        public var dockerVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.VersionInfo) : this() {
            this.agentHash = x.agentHash
            this.agentVersion = x.agentVersion
            this.dockerVersion = x.dockerVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.VersionInfo = VersionInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
