// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a set of Amazon ECS tasks in either an CodeDeploy or an `EXTERNAL` deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.
 */
public class TaskSet private constructor(builder: Builder) {
    /**
     * The capacity provider strategy that are associated with the task set.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * The Amazon Resource Name (ARN) of the cluster that the service that hosts the task set exists in.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The computed desired count for the task set. This is calculated by multiplying the service's `desiredCount` by the task set's `scale` percentage. The result is always rounded up. For example, if the computed desired count is 1.2, it rounds up to 2 tasks.
     */
    public val computedDesiredCount: kotlin.Int = builder.computedDesiredCount
    /**
     * The Unix timestamp for the time when the task set was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The external ID associated with the task set.
     *
     * If an CodeDeploy deployment created a task set, the `externalId` parameter contains the CodeDeploy deployment ID.
     *
     * If a task set is created for an external deployment and is associated with a service discovery registry, the `externalId` parameter contains the `ECS_TASK_SET_EXTERNAL_ID` Cloud Map attribute.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The Fargate ephemeral storage settings for the task set.
     */
    public val fargateEphemeralStorage: aws.sdk.kotlin.services.ecs.model.DeploymentEphemeralStorage? = builder.fargateEphemeralStorage
    /**
     * The ID of the task set.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The launch type the tasks in the task set are using. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * Details on a load balancer that are used with a task set.
     */
    public val loadBalancers: List<LoadBalancer>? = builder.loadBalancers
    /**
     * The network configuration for the task set.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The number of tasks in the task set that are in the `PENDING` status during a deployment. A task in the `PENDING` state is preparing to enter the `RUNNING` state. A task set enters the `PENDING` status when it launches for the first time or when it's restarted after being in the `STOPPED` state.
     */
    public val pendingCount: kotlin.Int = builder.pendingCount
    /**
     * The operating system that your tasks in the set are running on. A platform family is specified only for tasks that use the Fargate launch type.
     *
     *  All tasks in the set must have the same value.
     */
    public val platformFamily: kotlin.String? = builder.platformFamily
    /**
     * The Fargate platform version where the tasks in the task set are running. A platform version is only specified for tasks run on Fargate. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The number of tasks in the task set that are in the `RUNNING` status during a deployment. A task in the `RUNNING` state is running and ready for use.
     */
    public val runningCount: kotlin.Int = builder.runningCount
    /**
     * A floating-point percentage of your desired number of tasks to place and keep running in the task set.
     */
    public val scale: aws.sdk.kotlin.services.ecs.model.Scale? = builder.scale
    /**
     * The Amazon Resource Name (ARN) of the service the task set exists in.
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * The details for the service discovery registries to assign to this task set. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
     */
    public val serviceRegistries: List<ServiceRegistry>? = builder.serviceRegistries
    /**
     * The stability status. This indicates whether the task set has reached a steady state. If the following conditions are met, the task set are in `STEADY_STATE`:
     * + The task `runningCount` is equal to the `computedDesiredCount`.
     * + The `pendingCount` is `0`.
     * + There are no tasks that are running on container instances in the `DRAINING` status.
     * + All tasks are reporting a healthy status from the load balancers, service discovery, and container health checks.
     *
     * If any of those conditions aren't met, the stability status returns `STABILIZING`.
     */
    public val stabilityStatus: aws.sdk.kotlin.services.ecs.model.StabilityStatus? = builder.stabilityStatus
    /**
     * The Unix timestamp for the time when the task set stability status was retrieved.
     */
    public val stabilityStatusAt: aws.smithy.kotlin.runtime.time.Instant? = builder.stabilityStatusAt
    /**
     * The tag specified when a task set is started. If an CodeDeploy deployment created the task set, the `startedBy` parameter is `CODE_DEPLOY`. If an external deployment created the task set, the `startedBy` field isn't used.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The status of the task set. The following describes each state.
     *
     * ## PRIMARY
     * The task set is serving production traffic.
     *
     * ## ACTIVE
     * The task set isn't serving production traffic.
     *
     * ## DRAINING
     * The tasks in the task set are being stopped, and their corresponding targets are being deregistered from their target group.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The task definition that the task set is using.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition
    /**
     * The Amazon Resource Name (ARN) of the task set.
     */
    public val taskSetArn: kotlin.String? = builder.taskSetArn
    /**
     * The Unix timestamp for the time when the task set was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.TaskSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskSet(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("clusterArn=$clusterArn,")
        append("computedDesiredCount=$computedDesiredCount,")
        append("createdAt=$createdAt,")
        append("externalId=$externalId,")
        append("fargateEphemeralStorage=$fargateEphemeralStorage,")
        append("id=$id,")
        append("launchType=$launchType,")
        append("loadBalancers=$loadBalancers,")
        append("networkConfiguration=$networkConfiguration,")
        append("pendingCount=$pendingCount,")
        append("platformFamily=$platformFamily,")
        append("platformVersion=$platformVersion,")
        append("runningCount=$runningCount,")
        append("scale=$scale,")
        append("serviceArn=$serviceArn,")
        append("serviceRegistries=$serviceRegistries,")
        append("stabilityStatus=$stabilityStatus,")
        append("stabilityStatusAt=$stabilityStatusAt,")
        append("startedBy=$startedBy,")
        append("status=$status,")
        append("tags=$tags,")
        append("taskDefinition=$taskDefinition,")
        append("taskSetArn=$taskSetArn,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (computedDesiredCount)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (fargateEphemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancers?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pendingCount)
        result = 31 * result + (platformFamily?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (runningCount)
        result = 31 * result + (scale?.hashCode() ?: 0)
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (serviceRegistries?.hashCode() ?: 0)
        result = 31 * result + (stabilityStatus?.hashCode() ?: 0)
        result = 31 * result + (stabilityStatusAt?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        result = 31 * result + (taskSetArn?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskSet

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (clusterArn != other.clusterArn) return false
        if (computedDesiredCount != other.computedDesiredCount) return false
        if (createdAt != other.createdAt) return false
        if (externalId != other.externalId) return false
        if (fargateEphemeralStorage != other.fargateEphemeralStorage) return false
        if (id != other.id) return false
        if (launchType != other.launchType) return false
        if (loadBalancers != other.loadBalancers) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pendingCount != other.pendingCount) return false
        if (platformFamily != other.platformFamily) return false
        if (platformVersion != other.platformVersion) return false
        if (runningCount != other.runningCount) return false
        if (scale != other.scale) return false
        if (serviceArn != other.serviceArn) return false
        if (serviceRegistries != other.serviceRegistries) return false
        if (stabilityStatus != other.stabilityStatus) return false
        if (stabilityStatusAt != other.stabilityStatusAt) return false
        if (startedBy != other.startedBy) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (taskDefinition != other.taskDefinition) return false
        if (taskSetArn != other.taskSetArn) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.TaskSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capacity provider strategy that are associated with the task set.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * The Amazon Resource Name (ARN) of the cluster that the service that hosts the task set exists in.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The computed desired count for the task set. This is calculated by multiplying the service's `desiredCount` by the task set's `scale` percentage. The result is always rounded up. For example, if the computed desired count is 1.2, it rounds up to 2 tasks.
         */
        public var computedDesiredCount: kotlin.Int = 0
        /**
         * The Unix timestamp for the time when the task set was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The external ID associated with the task set.
         *
         * If an CodeDeploy deployment created a task set, the `externalId` parameter contains the CodeDeploy deployment ID.
         *
         * If a task set is created for an external deployment and is associated with a service discovery registry, the `externalId` parameter contains the `ECS_TASK_SET_EXTERNAL_ID` Cloud Map attribute.
         */
        public var externalId: kotlin.String? = null
        /**
         * The Fargate ephemeral storage settings for the task set.
         */
        public var fargateEphemeralStorage: aws.sdk.kotlin.services.ecs.model.DeploymentEphemeralStorage? = null
        /**
         * The ID of the task set.
         */
        public var id: kotlin.String? = null
        /**
         * The launch type the tasks in the task set are using. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * Details on a load balancer that are used with a task set.
         */
        public var loadBalancers: List<LoadBalancer>? = null
        /**
         * The network configuration for the task set.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * The number of tasks in the task set that are in the `PENDING` status during a deployment. A task in the `PENDING` state is preparing to enter the `RUNNING` state. A task set enters the `PENDING` status when it launches for the first time or when it's restarted after being in the `STOPPED` state.
         */
        public var pendingCount: kotlin.Int = 0
        /**
         * The operating system that your tasks in the set are running on. A platform family is specified only for tasks that use the Fargate launch type.
         *
         *  All tasks in the set must have the same value.
         */
        public var platformFamily: kotlin.String? = null
        /**
         * The Fargate platform version where the tasks in the task set are running. A platform version is only specified for tasks run on Fargate. For more information, see [Fargate platform versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The number of tasks in the task set that are in the `RUNNING` status during a deployment. A task in the `RUNNING` state is running and ready for use.
         */
        public var runningCount: kotlin.Int = 0
        /**
         * A floating-point percentage of your desired number of tasks to place and keep running in the task set.
         */
        public var scale: aws.sdk.kotlin.services.ecs.model.Scale? = null
        /**
         * The Amazon Resource Name (ARN) of the service the task set exists in.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * The details for the service discovery registries to assign to this task set. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
         */
        public var serviceRegistries: List<ServiceRegistry>? = null
        /**
         * The stability status. This indicates whether the task set has reached a steady state. If the following conditions are met, the task set are in `STEADY_STATE`:
         * + The task `runningCount` is equal to the `computedDesiredCount`.
         * + The `pendingCount` is `0`.
         * + There are no tasks that are running on container instances in the `DRAINING` status.
         * + All tasks are reporting a healthy status from the load balancers, service discovery, and container health checks.
         *
         * If any of those conditions aren't met, the stability status returns `STABILIZING`.
         */
        public var stabilityStatus: aws.sdk.kotlin.services.ecs.model.StabilityStatus? = null
        /**
         * The Unix timestamp for the time when the task set stability status was retrieved.
         */
        public var stabilityStatusAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tag specified when a task set is started. If an CodeDeploy deployment created the task set, the `startedBy` parameter is `CODE_DEPLOY`. If an external deployment created the task set, the `startedBy` field isn't used.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The status of the task set. The following describes each state.
         *
         * ## PRIMARY
         * The task set is serving production traffic.
         *
         * ## ACTIVE
         * The task set isn't serving production traffic.
         *
         * ## DRAINING
         * The tasks in the task set are being stopped, and their corresponding targets are being deregistered from their target group.
         */
        public var status: kotlin.String? = null
        /**
         * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The task definition that the task set is using.
         */
        public var taskDefinition: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the task set.
         */
        public var taskSetArn: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the task set was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.TaskSet) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.clusterArn = x.clusterArn
            this.computedDesiredCount = x.computedDesiredCount
            this.createdAt = x.createdAt
            this.externalId = x.externalId
            this.fargateEphemeralStorage = x.fargateEphemeralStorage
            this.id = x.id
            this.launchType = x.launchType
            this.loadBalancers = x.loadBalancers
            this.networkConfiguration = x.networkConfiguration
            this.pendingCount = x.pendingCount
            this.platformFamily = x.platformFamily
            this.platformVersion = x.platformVersion
            this.runningCount = x.runningCount
            this.scale = x.scale
            this.serviceArn = x.serviceArn
            this.serviceRegistries = x.serviceRegistries
            this.stabilityStatus = x.stabilityStatus
            this.stabilityStatusAt = x.stabilityStatusAt
            this.startedBy = x.startedBy
            this.status = x.status
            this.tags = x.tags
            this.taskDefinition = x.taskDefinition
            this.taskSetArn = x.taskSetArn
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.TaskSet = TaskSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DeploymentEphemeralStorage] inside the given [block]
         */
        public fun fargateEphemeralStorage(block: aws.sdk.kotlin.services.ecs.model.DeploymentEphemeralStorage.Builder.() -> kotlin.Unit) {
            this.fargateEphemeralStorage = aws.sdk.kotlin.services.ecs.model.DeploymentEphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.Scale] inside the given [block]
         */
        public fun scale(block: aws.sdk.kotlin.services.ecs.model.Scale.Builder.() -> kotlin.Unit) {
            this.scale = aws.sdk.kotlin.services.ecs.model.Scale.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
