// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The overrides that are associated with a task.
 */
public class TaskOverride private constructor(builder: Builder) {
    /**
     * One or more container overrides that are sent to a task.
     */
    public val containerOverrides: List<ContainerOverride>? = builder.containerOverrides
    /**
     * The CPU override for the task.
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The ephemeral storage setting override for the task.
     *
     * This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
     * + Linux platform version `1.4.0` or later.
     * + Windows platform version `1.0.0` or later.
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * The Amazon Resource Name (ARN) of the task execution role override for the task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The Elastic Inference accelerator override for the task.
     */
    public val inferenceAcceleratorOverrides: List<InferenceAcceleratorOverride>? = builder.inferenceAcceleratorOverrides
    /**
     * The memory override for the task.
     */
    public val memory: kotlin.String? = builder.memory
    /**
     * The Amazon Resource Name (ARN) of the role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see [IAM Role for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val taskRoleArn: kotlin.String? = builder.taskRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.TaskOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskOverride(")
        append("containerOverrides=$containerOverrides,")
        append("cpu=$cpu,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("executionRoleArn=$executionRoleArn,")
        append("inferenceAcceleratorOverrides=$inferenceAcceleratorOverrides,")
        append("memory=$memory,")
        append("taskRoleArn=$taskRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerOverrides?.hashCode() ?: 0
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (inferenceAcceleratorOverrides?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (taskRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskOverride

        if (containerOverrides != other.containerOverrides) return false
        if (cpu != other.cpu) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (inferenceAcceleratorOverrides != other.inferenceAcceleratorOverrides) return false
        if (memory != other.memory) return false
        if (taskRoleArn != other.taskRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.TaskOverride = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One or more container overrides that are sent to a task.
         */
        public var containerOverrides: List<ContainerOverride>? = null
        /**
         * The CPU override for the task.
         */
        public var cpu: kotlin.String? = null
        /**
         * The ephemeral storage setting override for the task.
         *
         * This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
         * + Linux platform version `1.4.0` or later.
         * + Windows platform version `1.0.0` or later.
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = null
        /**
         * The Amazon Resource Name (ARN) of the task execution role override for the task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The Elastic Inference accelerator override for the task.
         */
        public var inferenceAcceleratorOverrides: List<InferenceAcceleratorOverride>? = null
        /**
         * The memory override for the task.
         */
        public var memory: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see [IAM Role for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var taskRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.TaskOverride) : this() {
            this.containerOverrides = x.containerOverrides
            this.cpu = x.cpu
            this.ephemeralStorage = x.ephemeralStorage
            this.executionRoleArn = x.executionRoleArn
            this.inferenceAcceleratorOverrides = x.inferenceAcceleratorOverrides
            this.memory = x.memory
            this.taskRoleArn = x.taskRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.TaskOverride = TaskOverride(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.ecs.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.ecs.model.EphemeralStorage.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
