// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings are used to create each Amazon EBS volume, with one volume created for each task.
 */
public class TaskManagedEbsVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether the volume should be encrypted. If no value is specified, encryption is turned on by default. This parameter maps 1:1 with the `Encrypted` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The Linux filesystem type for the volume. For volumes created from a snapshot, you must specify the same filesystem type that the volume was using when the snapshot was created. If there is a filesystem type mismatch, the task will fail to start.
     *
     * The available filesystem types are  `ext3`, `ext4`, and `xfs`. If no value is specified, the `xfs` filesystem type is used by default.
     */
    public val filesystemType: aws.sdk.kotlin.services.ecs.model.TaskFilesystemType? = builder.filesystemType
    /**
     * The number of I/O operations per second (IOPS). For `gp3`, `io1`, and `io2` volumes, this represents the number of IOPS that are provisioned for the volume. For `gp2` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
     *
     * The following are the supported values for each volume type.
     * + `gp3`: 3,000 - 16,000 IOPS
     * + `io1`: 100 - 64,000 IOPS
     * + `io2`: 100 - 256,000 IOPS
     *
     * This parameter is required for `io1` and `io2` volume types. The default for `gp3` volumes is `3,000 IOPS`. This parameter is not supported for `st1`, `sc1`, or `standard` volume types.
     *
     * This parameter maps 1:1 with the `Iops` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption. When encryption is turned on and no Amazon Web Services Key Management Service key is specified, the default Amazon Web Services managed key for Amazon EBS volumes is used. This parameter maps 1:1 with the `KmsKeyId` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     *
     * Amazon Web Services authenticates the Amazon Web Services Key Management Service key asynchronously. Therefore, if you specify an ID, alias, or ARN that is invalid, the action can appear to complete, but eventually fails.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ARN of the IAM role to associate with this volume. This is the Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. We recommend using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role. For more information, see [Amazon ECS infrastructure IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html) in the *Amazon ECS Developer Guide*.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The size of the volume in GiB. You must specify either a volume size or a snapshot ID. If you specify a snapshot ID, the snapshot size is used for the volume size by default. You can optionally specify a volume size greater than or equal to the snapshot size. This parameter maps 1:1 with the `Size` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     *
     * The following are the supported volume size values for each volume type.
     * + `gp2` and `gp3`: 1-16,384
     * + `io1` and `io2`: 4-16,384
     * + `st1` and `sc1`: 125-16,384
     * + `standard`: 1-1,024
     */
    public val sizeInGib: kotlin.Int? = builder.sizeInGib
    /**
     * The snapshot that Amazon ECS uses to create the volume. You must specify either a snapshot ID or a volume size. This parameter maps 1:1 with the `SnapshotId` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The tags to apply to the volume. Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the `TagSpecifications.N` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     */
    public val tagSpecifications: List<EbsTagSpecification>? = builder.tagSpecifications
    /**
     * The termination policy for the volume when the task exits. This provides a way to control whether Amazon ECS terminates the Amazon EBS volume when the task stops.
     */
    public val terminationPolicy: aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy? = builder.terminationPolicy
    /**
     * The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s. This parameter maps 1:1 with the `Throughput` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
     *
     * This parameter is only supported for the `gp3` volume type.
     */
    public val throughput: kotlin.Int? = builder.throughput
    /**
     * The volume type. This parameter maps 1:1 with the `VolumeType` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*. For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html) in the *Amazon EC2 User Guide*.
     *
     * The following are the supported volume types.
     * + General Purpose SSD: `gp2`|`gp3`
     * + Provisioned IOPS SSD: `io1`|`io2`
     * + Throughput Optimized HDD: `st1`
     * + Cold HDD: `sc1`
     * + Magnetic: `standard`The magnetic volume type is not supported on Fargate.
     */
    public val volumeType: kotlin.String? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskManagedEbsVolumeConfiguration(")
        append("encrypted=$encrypted,")
        append("filesystemType=$filesystemType,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("roleArn=$roleArn,")
        append("sizeInGib=$sizeInGib,")
        append("snapshotId=$snapshotId,")
        append("tagSpecifications=$tagSpecifications,")
        append("terminationPolicy=$terminationPolicy,")
        append("throughput=$throughput,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encrypted?.hashCode() ?: 0
        result = 31 * result + (filesystemType?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (sizeInGib ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (terminationPolicy?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskManagedEbsVolumeConfiguration

        if (encrypted != other.encrypted) return false
        if (filesystemType != other.filesystemType) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (roleArn != other.roleArn) return false
        if (sizeInGib != other.sizeInGib) return false
        if (snapshotId != other.snapshotId) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (terminationPolicy != other.terminationPolicy) return false
        if (throughput != other.throughput) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the volume should be encrypted. If no value is specified, encryption is turned on by default. This parameter maps 1:1 with the `Encrypted` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The Linux filesystem type for the volume. For volumes created from a snapshot, you must specify the same filesystem type that the volume was using when the snapshot was created. If there is a filesystem type mismatch, the task will fail to start.
         *
         * The available filesystem types are  `ext3`, `ext4`, and `xfs`. If no value is specified, the `xfs` filesystem type is used by default.
         */
        public var filesystemType: aws.sdk.kotlin.services.ecs.model.TaskFilesystemType? = null
        /**
         * The number of I/O operations per second (IOPS). For `gp3`, `io1`, and `io2` volumes, this represents the number of IOPS that are provisioned for the volume. For `gp2` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         *
         * The following are the supported values for each volume type.
         * + `gp3`: 3,000 - 16,000 IOPS
         * + `io1`: 100 - 64,000 IOPS
         * + `io2`: 100 - 256,000 IOPS
         *
         * This parameter is required for `io1` and `io2` volume types. The default for `gp3` volumes is `3,000 IOPS`. This parameter is not supported for `st1`, `sc1`, or `standard` volume types.
         *
         * This parameter maps 1:1 with the `Iops` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) identifier of the Amazon Web Services Key Management Service key to use for Amazon EBS encryption. When encryption is turned on and no Amazon Web Services Key Management Service key is specified, the default Amazon Web Services managed key for Amazon EBS volumes is used. This parameter maps 1:1 with the `KmsKeyId` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         *
         * Amazon Web Services authenticates the Amazon Web Services Key Management Service key asynchronously. Therefore, if you specify an ID, alias, or ARN that is invalid, the action can appear to complete, but eventually fails.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The ARN of the IAM role to associate with this volume. This is the Amazon ECS infrastructure IAM role that is used to manage your Amazon Web Services infrastructure. We recommend using the Amazon ECS-managed `AmazonECSInfrastructureRolePolicyForVolumes` IAM policy with this role. For more information, see [Amazon ECS infrastructure IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html) in the *Amazon ECS Developer Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The size of the volume in GiB. You must specify either a volume size or a snapshot ID. If you specify a snapshot ID, the snapshot size is used for the volume size by default. You can optionally specify a volume size greater than or equal to the snapshot size. This parameter maps 1:1 with the `Size` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         *
         * The following are the supported volume size values for each volume type.
         * + `gp2` and `gp3`: 1-16,384
         * + `io1` and `io2`: 4-16,384
         * + `st1` and `sc1`: 125-16,384
         * + `standard`: 1-1,024
         */
        public var sizeInGib: kotlin.Int? = null
        /**
         * The snapshot that Amazon ECS uses to create the volume. You must specify either a snapshot ID or a volume size. This parameter maps 1:1 with the `SnapshotId` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The tags to apply to the volume. Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the `TagSpecifications.N` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         */
        public var tagSpecifications: List<EbsTagSpecification>? = null
        /**
         * The termination policy for the volume when the task exits. This provides a way to control whether Amazon ECS terminates the Amazon EBS volume when the task stops.
         */
        public var terminationPolicy: aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy? = null
        /**
         * The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s. This parameter maps 1:1 with the `Throughput` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         *
         * This parameter is only supported for the `gp3` volume type.
         */
        public var throughput: kotlin.Int? = null
        /**
         * The volume type. This parameter maps 1:1 with the `VolumeType` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*. For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html) in the *Amazon EC2 User Guide*.
         *
         * The following are the supported volume types.
         * + General Purpose SSD: `gp2`|`gp3`
         * + Provisioned IOPS SSD: `io1`|`io2`
         * + Throughput Optimized HDD: `st1`
         * + Cold HDD: `sc1`
         * + Magnetic: `standard`The magnetic volume type is not supported on Fargate.
         */
        public var volumeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeConfiguration) : this() {
            this.encrypted = x.encrypted
            this.filesystemType = x.filesystemType
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.roleArn = x.roleArn
            this.sizeInGib = x.sizeInGib
            this.snapshotId = x.snapshotId
            this.tagSpecifications = x.tagSpecifications
            this.terminationPolicy = x.terminationPolicy
            this.throughput = x.throughput
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeConfiguration = TaskManagedEbsVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy] inside the given [block]
         */
        public fun terminationPolicy(block: aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy.Builder.() -> kotlin.Unit) {
            this.terminationPolicy = aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
