// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
 */
public class ExecuteCommandLogConfiguration private constructor(builder: Builder) {
    /**
     * Determines whether to use encryption on the CloudWatch logs. If not specified, encryption will be off.
     */
    public val cloudWatchEncryptionEnabled: kotlin.Boolean = builder.cloudWatchEncryptionEnabled
    /**
     * The name of the CloudWatch log group to send logs to.
     *
     * The CloudWatch log group must already be created.
     */
    public val cloudWatchLogGroupName: kotlin.String? = builder.cloudWatchLogGroupName
    /**
     * The name of the S3 bucket to send logs to.
     *
     * The S3 bucket must already be created.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Determines whether to use encryption on the S3 logs. If not specified, encryption is not used.
     */
    public val s3EncryptionEnabled: kotlin.Boolean = builder.s3EncryptionEnabled
    /**
     * An optional folder in the S3 bucket to place logs in.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteCommandLogConfiguration(")
        append("cloudWatchEncryptionEnabled=$cloudWatchEncryptionEnabled,")
        append("cloudWatchLogGroupName=$cloudWatchLogGroupName,")
        append("s3BucketName=$s3BucketName,")
        append("s3EncryptionEnabled=$s3EncryptionEnabled,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchEncryptionEnabled.hashCode()
        result = 31 * result + (cloudWatchLogGroupName?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3EncryptionEnabled.hashCode())
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteCommandLogConfiguration

        if (cloudWatchEncryptionEnabled != other.cloudWatchEncryptionEnabled) return false
        if (cloudWatchLogGroupName != other.cloudWatchLogGroupName) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3EncryptionEnabled != other.s3EncryptionEnabled) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines whether to use encryption on the CloudWatch logs. If not specified, encryption will be off.
         */
        public var cloudWatchEncryptionEnabled: kotlin.Boolean = false
        /**
         * The name of the CloudWatch log group to send logs to.
         *
         * The CloudWatch log group must already be created.
         */
        public var cloudWatchLogGroupName: kotlin.String? = null
        /**
         * The name of the S3 bucket to send logs to.
         *
         * The S3 bucket must already be created.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * Determines whether to use encryption on the S3 logs. If not specified, encryption is not used.
         */
        public var s3EncryptionEnabled: kotlin.Boolean = false
        /**
         * An optional folder in the S3 bucket to place logs in.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration) : this() {
            this.cloudWatchEncryptionEnabled = x.cloudWatchEncryptionEnabled
            this.cloudWatchLogGroupName = x.cloudWatchLogGroupName
            this.s3BucketName = x.s3BucketName
            this.s3EncryptionEnabled = x.s3EncryptionEnabled
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration = ExecuteCommandLogConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
