// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of the execute command configuration.
 */
public class ExecuteCommandConfiguration private constructor(builder: Builder) {
    /**
     * Specify an Key Management Service key ID to encrypt the data between the local client and the container.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When `logging=OVERRIDE` is specified, a `logConfiguration` must be provided.
     */
    public val logConfiguration: aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration? = builder.logConfiguration
    /**
     * The log setting to use for redirecting logs for your execute command results. The following log settings are available.
     * + `NONE`: The execute command session is not logged.
     * + `DEFAULT`: The `awslogs` configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no `awslogs` log driver is configured in the task definition, the output won't be logged.
     * + `OVERRIDE`: Specify the logging details as a part of `logConfiguration`. If the `OVERRIDE` logging option is specified, the `logConfiguration` is required.
     */
    public val logging: aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogging? = builder.logging

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ExecuteCommandConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteCommandConfiguration(")
        append("kmsKeyId=$kmsKeyId,")
        append("logConfiguration=$logConfiguration,")
        append("logging=$logging")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteCommandConfiguration

        if (kmsKeyId != other.kmsKeyId) return false
        if (logConfiguration != other.logConfiguration) return false
        if (logging != other.logging) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ExecuteCommandConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify an Key Management Service key ID to encrypt the data between the local client and the container.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When `logging=OVERRIDE` is specified, a `logConfiguration` must be provided.
         */
        public var logConfiguration: aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration? = null
        /**
         * The log setting to use for redirecting logs for your execute command results. The following log settings are available.
         * + `NONE`: The execute command session is not logged.
         * + `DEFAULT`: The `awslogs` configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no `awslogs` log driver is configured in the task definition, the output won't be logged.
         * + `OVERRIDE`: Specify the logging details as a part of `logConfiguration`. If the `OVERRIDE` logging option is specified, the `logConfiguration` is required.
         */
        public var logging: aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogging? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ExecuteCommandConfiguration) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.logConfiguration = x.logConfiguration
            this.logging = x.logging
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ExecuteCommandConfiguration = ExecuteCommandConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.ecs.model.ExecuteCommandLogConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
