// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * You can enable a restart policy for each container defined in your task definition, to overcome transient failures faster and maintain task availability. When you enable a restart policy for a container, Amazon ECS can restart the container if it exits, without needing to replace the task. For more information, see [Restart individual containers in Amazon ECS tasks with container restart policies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class ContainerRestartPolicy private constructor(builder: Builder) {
    /**
     * Specifies whether a restart policy is enabled for the container.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * A list of exit codes that Amazon ECS will ignore and not attempt a restart on. You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
     */
    public val ignoredExitCodes: List<Int>? = builder.ignoredExitCodes
    /**
     * A period of time (in seconds) that the container must run for before a restart can be attempted. A container can be restarted only once every `restartAttemptPeriod` seconds. If a container isn't able to run for this time period and exits early, it will not be restarted. You can set a minimum `restartAttemptPeriod` of 60 seconds and a maximum `restartAttemptPeriod` of 1800 seconds. By default, a container must run for 300 seconds before it can be restarted.
     */
    public val restartAttemptPeriod: kotlin.Int? = builder.restartAttemptPeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ContainerRestartPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerRestartPolicy(")
        append("enabled=$enabled,")
        append("ignoredExitCodes=$ignoredExitCodes,")
        append("restartAttemptPeriod=$restartAttemptPeriod")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (ignoredExitCodes?.hashCode() ?: 0)
        result = 31 * result + (restartAttemptPeriod ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerRestartPolicy

        if (enabled != other.enabled) return false
        if (ignoredExitCodes != other.ignoredExitCodes) return false
        if (restartAttemptPeriod != other.restartAttemptPeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ContainerRestartPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether a restart policy is enabled for the container.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A list of exit codes that Amazon ECS will ignore and not attempt a restart on. You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
         */
        public var ignoredExitCodes: List<Int>? = null
        /**
         * A period of time (in seconds) that the container must run for before a restart can be attempted. A container can be restarted only once every `restartAttemptPeriod` seconds. If a container isn't able to run for this time period and exits early, it will not be restarted. You can set a minimum `restartAttemptPeriod` of 60 seconds and a maximum `restartAttemptPeriod` of 1800 seconds. By default, a container must run for 300 seconds before it can be restarted.
         */
        public var restartAttemptPeriod: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ContainerRestartPolicy) : this() {
            this.enabled = x.enabled
            this.ignoredExitCodes = x.ignoredExitCodes
            this.restartAttemptPeriod = x.restartAttemptPeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ContainerRestartPolicy = ContainerRestartPolicy(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
