// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing the networking details for a task or service. For example `awsVpcConfiguration={subnets=["subnet-12344321"],securityGroups=["sg-12344321"]}`.
 */
public class AwsVpcConfiguration private constructor(builder: Builder) {
    /**
     * Whether the task's elastic network interface receives a public IP address. The default value is `DISABLED`.
     */
    public val assignPublicIp: aws.sdk.kotlin.services.ecs.model.AssignPublicIp? = builder.assignPublicIp
    /**
     * The IDs of the security groups associated with the task or service. If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified per `awsvpcConfiguration`.
     *
     * All specified security groups must be from the same VPC.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The IDs of the subnets associated with the task or service. There's a limit of 16 subnets that can be specified per `awsvpcConfiguration`.
     *
     * All specified subnets must be from the same VPC.
     */
    public val subnets: List<String> = requireNotNull(builder.subnets) { "A non-null value must be provided for subnets" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.AwsVpcConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsVpcConfiguration(")
        append("assignPublicIp=$assignPublicIp,")
        append("securityGroups=$securityGroups,")
        append("subnets=$subnets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignPublicIp?.hashCode() ?: 0
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnets.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsVpcConfiguration

        if (assignPublicIp != other.assignPublicIp) return false
        if (securityGroups != other.securityGroups) return false
        if (subnets != other.subnets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.AwsVpcConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether the task's elastic network interface receives a public IP address. The default value is `DISABLED`.
         */
        public var assignPublicIp: aws.sdk.kotlin.services.ecs.model.AssignPublicIp? = null
        /**
         * The IDs of the security groups associated with the task or service. If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified per `awsvpcConfiguration`.
         *
         * All specified security groups must be from the same VPC.
         */
        public var securityGroups: List<String>? = null
        /**
         * The IDs of the subnets associated with the task or service. There's a limit of 16 subnets that can be specified per `awsvpcConfiguration`.
         *
         * All specified subnets must be from the same VPC.
         */
        public var subnets: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.AwsVpcConfiguration) : this() {
            this.assignPublicIp = x.assignPublicIp
            this.securityGroups = x.securityGroups
            this.subnets = x.subnets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.AwsVpcConfiguration = AwsVpcConfiguration(this)

        internal fun correctErrors(): Builder {
            if (subnets == null) subnets = emptyList()
            return this
        }
    }
}
