// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.CapacityProviderStrategyItem
import aws.sdk.kotlin.services.ecs.model.LaunchType
import aws.sdk.kotlin.services.ecs.model.NetworkConfiguration
import aws.sdk.kotlin.services.ecs.model.PlacementConstraint
import aws.sdk.kotlin.services.ecs.model.PlacementStrategy
import aws.sdk.kotlin.services.ecs.model.PropagateTags
import aws.sdk.kotlin.services.ecs.model.RunTaskRequest
import aws.sdk.kotlin.services.ecs.model.Tag
import aws.sdk.kotlin.services.ecs.model.TaskOverride
import aws.sdk.kotlin.services.ecs.model.TaskVolumeConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RunTaskOperationSerializer: HttpSerializer.NonStreaming<RunTaskRequest> {
    override fun serialize(context: ExecutionContext, input: RunTaskRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeRunTaskOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeRunTaskOperationBody(context: ExecutionContext, input: RunTaskRequest): ByteArray {
    val serializer = JsonSerializer()
    val CAPACITYPROVIDERSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("capacityProviderStrategy"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cluster"))
    val COUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("count"))
    val ENABLEECSMANAGEDTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableECSManagedTags"))
    val ENABLEEXECUTECOMMAND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableExecuteCommand"))
    val GROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("group"))
    val LAUNCHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("launchType"))
    val NETWORKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("networkConfiguration"))
    val OVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("overrides"))
    val PLACEMENTCONSTRAINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("placementConstraints"))
    val PLACEMENTSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("placementStrategy"))
    val PLATFORMVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platformVersion"))
    val PROPAGATETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("propagateTags"))
    val REFERENCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("referenceId"))
    val STARTEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startedBy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TASKDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskDefinition"))
    val VOLUMECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("volumeConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITYPROVIDERSTRATEGY_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CLUSTER_DESCRIPTOR)
        field(COUNT_DESCRIPTOR)
        field(ENABLEECSMANAGEDTAGS_DESCRIPTOR)
        field(ENABLEEXECUTECOMMAND_DESCRIPTOR)
        field(GROUP_DESCRIPTOR)
        field(LAUNCHTYPE_DESCRIPTOR)
        field(NETWORKCONFIGURATION_DESCRIPTOR)
        field(OVERRIDES_DESCRIPTOR)
        field(PLACEMENTCONSTRAINTS_DESCRIPTOR)
        field(PLACEMENTSTRATEGY_DESCRIPTOR)
        field(PLATFORMVERSION_DESCRIPTOR)
        field(PROPAGATETAGS_DESCRIPTOR)
        field(REFERENCEID_DESCRIPTOR)
        field(STARTEDBY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TASKDEFINITION_DESCRIPTOR)
        field(VOLUMECONFIGURATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.capacityProviderStrategy != null) {
            listField(CAPACITYPROVIDERSTRATEGY_DESCRIPTOR) {
                for (el0 in input.capacityProviderStrategy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCapacityProviderStrategyItemDocument))
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.cluster?.let { field(CLUSTER_DESCRIPTOR, it) }
        input.count?.let { field(COUNT_DESCRIPTOR, it) }
        input.enableEcsManagedTags?.let { field(ENABLEECSMANAGEDTAGS_DESCRIPTOR, it) }
        input.enableExecuteCommand?.let { field(ENABLEEXECUTECOMMAND_DESCRIPTOR, it) }
        input.group?.let { field(GROUP_DESCRIPTOR, it) }
        input.launchType?.let { field(LAUNCHTYPE_DESCRIPTOR, it.value) }
        input.networkConfiguration?.let { field(NETWORKCONFIGURATION_DESCRIPTOR, it, ::serializeNetworkConfigurationDocument) }
        input.overrides?.let { field(OVERRIDES_DESCRIPTOR, it, ::serializeTaskOverrideDocument) }
        if (input.placementConstraints != null) {
            listField(PLACEMENTCONSTRAINTS_DESCRIPTOR) {
                for (el0 in input.placementConstraints) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePlacementConstraintDocument))
                }
            }
        }
        if (input.placementStrategy != null) {
            listField(PLACEMENTSTRATEGY_DESCRIPTOR) {
                for (el0 in input.placementStrategy) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePlacementStrategyDocument))
                }
            }
        }
        input.platformVersion?.let { field(PLATFORMVERSION_DESCRIPTOR, it) }
        input.propagateTags?.let { field(PROPAGATETAGS_DESCRIPTOR, it.value) }
        input.referenceId?.let { field(REFERENCEID_DESCRIPTOR, it) }
        input.startedBy?.let { field(STARTEDBY_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.taskDefinition?.let { field(TASKDEFINITION_DESCRIPTOR, it) }
        if (input.volumeConfigurations != null) {
            listField(VOLUMECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.volumeConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTaskVolumeConfigurationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
