// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that represents the timeout configurations for Service Connect.
 *
 * If `idleTimeout` is set to a time that is less than `perRequestTimeout`, the connection will close when the `idleTimeout` is reached and not the `perRequestTimeout`.
 */
public class TimeoutConfiguration private constructor(builder: Builder) {
    /**
     * The amount of time in seconds a connection will stay active while idle. A value of `0` can be set to disable `idleTimeout`.
     *
     * The `idleTimeout` default for `HTTP`/`HTTP2`/`GRPC` is 5 minutes.
     *
     * The `idleTimeout` default for `TCP` is 1 hour.
     */
    public val idleTimeoutSeconds: kotlin.Int? = builder.idleTimeoutSeconds
    /**
     * The amount of time waiting for the upstream to respond with a complete response per request. A value of `0` can be set to disable `perRequestTimeout`. `perRequestTimeout` can only be set if Service Connect `appProtocol` isn't `TCP`. Only `idleTimeout` is allowed for `TCP``appProtocol`.
     */
    public val perRequestTimeoutSeconds: kotlin.Int? = builder.perRequestTimeoutSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeoutConfiguration(")
        append("idleTimeoutSeconds=$idleTimeoutSeconds,")
        append("perRequestTimeoutSeconds=$perRequestTimeoutSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = idleTimeoutSeconds ?: 0
        result = 31 * result + (perRequestTimeoutSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeoutConfiguration

        if (idleTimeoutSeconds != other.idleTimeoutSeconds) return false
        if (perRequestTimeoutSeconds != other.perRequestTimeoutSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of time in seconds a connection will stay active while idle. A value of `0` can be set to disable `idleTimeout`.
         *
         * The `idleTimeout` default for `HTTP`/`HTTP2`/`GRPC` is 5 minutes.
         *
         * The `idleTimeout` default for `TCP` is 1 hour.
         */
        public var idleTimeoutSeconds: kotlin.Int? = null
        /**
         * The amount of time waiting for the upstream to respond with a complete response per request. A value of `0` can be set to disable `perRequestTimeout`. `perRequestTimeout` can only be set if Service Connect `appProtocol` isn't `TCP`. Only `idleTimeout` is allowed for `TCP``appProtocol`.
         */
        public var perRequestTimeoutSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration) : this() {
            this.idleTimeoutSeconds = x.idleTimeoutSeconds
            this.perRequestTimeoutSeconds = x.perRequestTimeoutSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration = TimeoutConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
