// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details on a task in a cluster.
 */
public class Task private constructor(builder: Builder) {
    /**
     * The Elastic Network Adapter that's associated with the task if the task uses the `awsvpc` network mode.
     */
    public val attachments: List<Attachment>? = builder.attachments
    /**
     * The attributes of the task
     */
    public val attributes: List<Attribute>? = builder.attributes
    /**
     * The Availability Zone for the task.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The capacity provider that's associated with the task.
     */
    public val capacityProviderName: kotlin.String? = builder.capacityProviderName
    /**
     * The ARN of the cluster that hosts the task.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The connectivity status of a task.
     */
    public val connectivity: aws.sdk.kotlin.services.ecs.model.Connectivity? = builder.connectivity
    /**
     * The Unix timestamp for the time when the task last went into `CONNECTED` status.
     */
    public val connectivityAt: aws.smithy.kotlin.runtime.time.Instant? = builder.connectivityAt
    /**
     * The ARN of the container instances that host the task.
     */
    public val containerInstanceArn: kotlin.String? = builder.containerInstanceArn
    /**
     * The containers that's associated with the task.
     */
    public val containers: List<Container>? = builder.containers
    /**
     * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer using CPU units (for example, `1024`). It can also be expressed as a string using vCPUs (for example, `1 vCPU` or `1 vcpu`). String values are converted to an integer that indicates the CPU units when the task definition is registered.
     *
     * If you use the EC2 launch type, this field is optional. Supported values are between `128` CPU units (`0.125` vCPUs) and `10240` CPU units (`10` vCPUs).
     *
     * If you use the Fargate launch type, this field is required. You must use one of the following values. These values determine the range of supported values for the `memory` parameter:
     *
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * + 256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * + 512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * + 1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     * + 2048 (2 vCPU) - Available `memory` values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * + 4096 (4 vCPU) - Available `memory` values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * + 8192 (8 vCPU) - Available `memory` values: 16 GB and 60 GB in 4 GB incrementsThis option requires Linux platform `1.4.0` or later.
     * + 16384 (16vCPU) - Available `memory` values: 32GB and 120 GB in 8 GB incrementsThis option requires Linux platform `1.4.0` or later.
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task entered the `PENDING` state.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The desired status of the task. For more information, see [Task Lifecycle](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
     */
    public val desiredStatus: kotlin.String? = builder.desiredStatus
    /**
     * Determines whether execute command functionality is turned on for this task. If `true`, execute command functionality is turned on all the containers in the task.
     */
    public val enableExecuteCommand: kotlin.Boolean = builder.enableExecuteCommand
    /**
     * The ephemeral storage settings for the task.
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * The Unix timestamp for the time when the task execution stopped.
     */
    public val executionStoppedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.executionStoppedAt
    /**
     * The Fargate ephemeral storage settings for the task.
     */
    public val fargateEphemeralStorage: aws.sdk.kotlin.services.ecs.model.TaskEphemeralStorage? = builder.fargateEphemeralStorage
    /**
     * The name of the task group that's associated with the task.
     */
    public val group: kotlin.String? = builder.group
    /**
     * The health status for the task. It's determined by the health of the essential containers in the task. If all essential containers in the task are reporting as `HEALTHY`, the task status also reports as `HEALTHY`. If any essential containers in the task are reporting as `UNHEALTHY` or `UNKNOWN`, the task status also reports as `UNHEALTHY` or `UNKNOWN`.
     *
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container image and not specified in the container definition. For example, this includes those specified in a parent image or from the image's Dockerfile. Health check parameters that are specified in a container definition override any Docker health checks that are found in the container image.
     */
    public val healthStatus: aws.sdk.kotlin.services.ecs.model.HealthStatus? = builder.healthStatus
    /**
     * The Elastic Inference accelerator that's associated with the task.
     */
    public val inferenceAccelerators: List<InferenceAccelerator>? = builder.inferenceAccelerators
    /**
     * The last known status for the task. For more information, see [Task Lifecycle](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
     */
    public val lastStatus: kotlin.String? = builder.lastStatus
    /**
     * The infrastructure where your task runs on. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an integer using MiB (for example, `1024`). If it's expressed as a string using GB (for example, `1GB` or `1 GB`), it's converted to an integer indicating the MiB when the task definition is registered.
     *
     * If you use the EC2 launch type, this field is optional.
     *
     * If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines the range of supported values for the `cpu` parameter.
     * + 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256 (.25 vCPU)
     * + 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu` values: 512 (.5 vCPU)
     * + 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
     * + Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available `cpu` values: 2048 (2 vCPU)
     * + Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available `cpu` values: 4096 (4 vCPU)
     * + Between 16 GB and 60 GB in 4 GB increments - Available `cpu` values: 8192 (8 vCPU)This option requires Linux platform `1.4.0` or later.
     * + Between 32GB and 120 GB in 8 GB increments - Available `cpu` values: 16384 (16 vCPU)This option requires Linux platform `1.4.0` or later.
     */
    public val memory: kotlin.String? = builder.memory
    /**
     * One or more container overrides.
     */
    public val overrides: aws.sdk.kotlin.services.ecs.model.TaskOverride? = builder.overrides
    /**
     * The operating system that your tasks are running on. A platform family is specified only for tasks that use the Fargate launch type.
     *
     *  All tasks that run as part of this service must use the same `platformFamily` value as the service (for example, `LINUX.`).
     */
    public val platformFamily: kotlin.String? = builder.platformFamily
    /**
     * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate launch type. If you didn't specify one, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The Unix timestamp for the time when the container image pull began.
     */
    public val pullStartedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.pullStartedAt
    /**
     * The Unix timestamp for the time when the container image pull completed.
     */
    public val pullStoppedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.pullStoppedAt
    /**
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task transitioned from the `PENDING` state to the `RUNNING` state.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The tag specified when a task is started. If an Amazon ECS service started the task, the `startedBy` parameter contains the deployment ID of that service.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The stop code indicating why a task was stopped. The `stoppedReason` might contain additional details.
     *
     * For more information about stop code, see [Stopped tasks error codes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html) in the *Amazon ECS Developer Guide*.
     */
    public val stopCode: aws.sdk.kotlin.services.ecs.model.TaskStopCode? = builder.stopCode
    /**
     * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task transitioned from the `RUNNING` state to the `STOPPED` state.
     */
    public val stoppedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.stoppedAt
    /**
     * The reason that the task was stopped.
     */
    public val stoppedReason: kotlin.String? = builder.stoppedReason
    /**
     * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task transitions from the `RUNNING` state to `STOPPING`.
     */
    public val stoppingAt: aws.smithy.kotlin.runtime.time.Instant? = builder.stoppingAt
    /**
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key and an optional value. You define both the key and value.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the task.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The ARN of the task definition that creates the task.
     */
    public val taskDefinitionArn: kotlin.String? = builder.taskDefinitionArn
    /**
     * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch Events for the task (inside the `detail` object) to verify that the version in your event stream is current.
     */
    public val version: kotlin.Long = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Task = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Task(")
        append("attachments=$attachments,")
        append("attributes=$attributes,")
        append("availabilityZone=$availabilityZone,")
        append("capacityProviderName=$capacityProviderName,")
        append("clusterArn=$clusterArn,")
        append("connectivity=$connectivity,")
        append("connectivityAt=$connectivityAt,")
        append("containerInstanceArn=$containerInstanceArn,")
        append("containers=$containers,")
        append("cpu=$cpu,")
        append("createdAt=$createdAt,")
        append("desiredStatus=$desiredStatus,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("executionStoppedAt=$executionStoppedAt,")
        append("fargateEphemeralStorage=$fargateEphemeralStorage,")
        append("group=$group,")
        append("healthStatus=$healthStatus,")
        append("inferenceAccelerators=$inferenceAccelerators,")
        append("lastStatus=$lastStatus,")
        append("launchType=$launchType,")
        append("memory=$memory,")
        append("overrides=$overrides,")
        append("platformFamily=$platformFamily,")
        append("platformVersion=$platformVersion,")
        append("pullStartedAt=$pullStartedAt,")
        append("pullStoppedAt=$pullStoppedAt,")
        append("startedAt=$startedAt,")
        append("startedBy=$startedBy,")
        append("stopCode=$stopCode,")
        append("stoppedAt=$stoppedAt,")
        append("stoppedReason=$stoppedReason,")
        append("stoppingAt=$stoppingAt,")
        append("tags=$tags,")
        append("taskArn=$taskArn,")
        append("taskDefinitionArn=$taskDefinitionArn,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (capacityProviderName?.hashCode() ?: 0)
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (connectivity?.hashCode() ?: 0)
        result = 31 * result + (connectivityAt?.hashCode() ?: 0)
        result = 31 * result + (containerInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (containers?.hashCode() ?: 0)
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (desiredStatus?.hashCode() ?: 0)
        result = 31 * result + (enableExecuteCommand.hashCode())
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (executionStoppedAt?.hashCode() ?: 0)
        result = 31 * result + (fargateEphemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (inferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (lastStatus?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (platformFamily?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (pullStartedAt?.hashCode() ?: 0)
        result = 31 * result + (pullStoppedAt?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (stopCode?.hashCode() ?: 0)
        result = 31 * result + (stoppedAt?.hashCode() ?: 0)
        result = 31 * result + (stoppedReason?.hashCode() ?: 0)
        result = 31 * result + (stoppingAt?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Task

        if (attachments != other.attachments) return false
        if (attributes != other.attributes) return false
        if (availabilityZone != other.availabilityZone) return false
        if (capacityProviderName != other.capacityProviderName) return false
        if (clusterArn != other.clusterArn) return false
        if (connectivity != other.connectivity) return false
        if (connectivityAt != other.connectivityAt) return false
        if (containerInstanceArn != other.containerInstanceArn) return false
        if (containers != other.containers) return false
        if (cpu != other.cpu) return false
        if (createdAt != other.createdAt) return false
        if (desiredStatus != other.desiredStatus) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (executionStoppedAt != other.executionStoppedAt) return false
        if (fargateEphemeralStorage != other.fargateEphemeralStorage) return false
        if (group != other.group) return false
        if (healthStatus != other.healthStatus) return false
        if (inferenceAccelerators != other.inferenceAccelerators) return false
        if (lastStatus != other.lastStatus) return false
        if (launchType != other.launchType) return false
        if (memory != other.memory) return false
        if (overrides != other.overrides) return false
        if (platformFamily != other.platformFamily) return false
        if (platformVersion != other.platformVersion) return false
        if (pullStartedAt != other.pullStartedAt) return false
        if (pullStoppedAt != other.pullStoppedAt) return false
        if (startedAt != other.startedAt) return false
        if (startedBy != other.startedBy) return false
        if (stopCode != other.stopCode) return false
        if (stoppedAt != other.stoppedAt) return false
        if (stoppedReason != other.stoppedReason) return false
        if (stoppingAt != other.stoppingAt) return false
        if (tags != other.tags) return false
        if (taskArn != other.taskArn) return false
        if (taskDefinitionArn != other.taskDefinitionArn) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Task = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Elastic Network Adapter that's associated with the task if the task uses the `awsvpc` network mode.
         */
        public var attachments: List<Attachment>? = null
        /**
         * The attributes of the task
         */
        public var attributes: List<Attribute>? = null
        /**
         * The Availability Zone for the task.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The capacity provider that's associated with the task.
         */
        public var capacityProviderName: kotlin.String? = null
        /**
         * The ARN of the cluster that hosts the task.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The connectivity status of a task.
         */
        public var connectivity: aws.sdk.kotlin.services.ecs.model.Connectivity? = null
        /**
         * The Unix timestamp for the time when the task last went into `CONNECTED` status.
         */
        public var connectivityAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the container instances that host the task.
         */
        public var containerInstanceArn: kotlin.String? = null
        /**
         * The containers that's associated with the task.
         */
        public var containers: List<Container>? = null
        /**
         * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer using CPU units (for example, `1024`). It can also be expressed as a string using vCPUs (for example, `1 vCPU` or `1 vcpu`). String values are converted to an integer that indicates the CPU units when the task definition is registered.
         *
         * If you use the EC2 launch type, this field is optional. Supported values are between `128` CPU units (`0.125` vCPUs) and `10240` CPU units (`10` vCPUs).
         *
         * If you use the Fargate launch type, this field is required. You must use one of the following values. These values determine the range of supported values for the `memory` parameter:
         *
         * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         * + 256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * + 512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * + 1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * + 2048 (2 vCPU) - Available `memory` values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         * + 4096 (4 vCPU) - Available `memory` values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * + 8192 (8 vCPU) - Available `memory` values: 16 GB and 60 GB in 4 GB incrementsThis option requires Linux platform `1.4.0` or later.
         * + 16384 (16vCPU) - Available `memory` values: 32GB and 120 GB in 8 GB incrementsThis option requires Linux platform `1.4.0` or later.
         */
        public var cpu: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task entered the `PENDING` state.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The desired status of the task. For more information, see [Task Lifecycle](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
         */
        public var desiredStatus: kotlin.String? = null
        /**
         * Determines whether execute command functionality is turned on for this task. If `true`, execute command functionality is turned on all the containers in the task.
         */
        public var enableExecuteCommand: kotlin.Boolean = false
        /**
         * The ephemeral storage settings for the task.
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = null
        /**
         * The Unix timestamp for the time when the task execution stopped.
         */
        public var executionStoppedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Fargate ephemeral storage settings for the task.
         */
        public var fargateEphemeralStorage: aws.sdk.kotlin.services.ecs.model.TaskEphemeralStorage? = null
        /**
         * The name of the task group that's associated with the task.
         */
        public var group: kotlin.String? = null
        /**
         * The health status for the task. It's determined by the health of the essential containers in the task. If all essential containers in the task are reporting as `HEALTHY`, the task status also reports as `HEALTHY`. If any essential containers in the task are reporting as `UNHEALTHY` or `UNKNOWN`, the task status also reports as `UNHEALTHY` or `UNKNOWN`.
         *
         * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container image and not specified in the container definition. For example, this includes those specified in a parent image or from the image's Dockerfile. Health check parameters that are specified in a container definition override any Docker health checks that are found in the container image.
         */
        public var healthStatus: aws.sdk.kotlin.services.ecs.model.HealthStatus? = null
        /**
         * The Elastic Inference accelerator that's associated with the task.
         */
        public var inferenceAccelerators: List<InferenceAccelerator>? = null
        /**
         * The last known status for the task. For more information, see [Task Lifecycle](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html).
         */
        public var lastStatus: kotlin.String? = null
        /**
         * The infrastructure where your task runs on. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an integer using MiB (for example, `1024`). If it's expressed as a string using GB (for example, `1GB` or `1 GB`), it's converted to an integer indicating the MiB when the task definition is registered.
         *
         * If you use the EC2 launch type, this field is optional.
         *
         * If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines the range of supported values for the `cpu` parameter.
         * + 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256 (.25 vCPU)
         * + 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu` values: 512 (.5 vCPU)
         * + 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
         * + Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available `cpu` values: 2048 (2 vCPU)
         * + Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available `cpu` values: 4096 (4 vCPU)
         * + Between 16 GB and 60 GB in 4 GB increments - Available `cpu` values: 8192 (8 vCPU)This option requires Linux platform `1.4.0` or later.
         * + Between 32GB and 120 GB in 8 GB increments - Available `cpu` values: 16384 (16 vCPU)This option requires Linux platform `1.4.0` or later.
         */
        public var memory: kotlin.String? = null
        /**
         * One or more container overrides.
         */
        public var overrides: aws.sdk.kotlin.services.ecs.model.TaskOverride? = null
        /**
         * The operating system that your tasks are running on. A platform family is specified only for tasks that use the Fargate launch type.
         *
         *  All tasks that run as part of this service must use the same `platformFamily` value as the service (for example, `LINUX.`).
         */
        public var platformFamily: kotlin.String? = null
        /**
         * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate launch type. If you didn't specify one, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the container image pull began.
         */
        public var pullStartedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix timestamp for the time when the container image pull completed.
         */
        public var pullStoppedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task transitioned from the `PENDING` state to the `RUNNING` state.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tag specified when a task is started. If an Amazon ECS service started the task, the `startedBy` parameter contains the deployment ID of that service.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The stop code indicating why a task was stopped. The `stoppedReason` might contain additional details.
         *
         * For more information about stop code, see [Stopped tasks error codes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html) in the *Amazon ECS Developer Guide*.
         */
        public var stopCode: aws.sdk.kotlin.services.ecs.model.TaskStopCode? = null
        /**
         * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task transitioned from the `RUNNING` state to the `STOPPED` state.
         */
        public var stoppedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason that the task was stopped.
         */
        public var stoppedReason: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task transitions from the `RUNNING` state to `STOPPING`.
         */
        public var stoppingAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key and an optional value. You define both the key and value.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the task.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The ARN of the task definition that creates the task.
         */
        public var taskDefinitionArn: kotlin.String? = null
        /**
         * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch Events for the task (inside the `detail` object) to verify that the version in your event stream is current.
         */
        public var version: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Task) : this() {
            this.attachments = x.attachments
            this.attributes = x.attributes
            this.availabilityZone = x.availabilityZone
            this.capacityProviderName = x.capacityProviderName
            this.clusterArn = x.clusterArn
            this.connectivity = x.connectivity
            this.connectivityAt = x.connectivityAt
            this.containerInstanceArn = x.containerInstanceArn
            this.containers = x.containers
            this.cpu = x.cpu
            this.createdAt = x.createdAt
            this.desiredStatus = x.desiredStatus
            this.enableExecuteCommand = x.enableExecuteCommand
            this.ephemeralStorage = x.ephemeralStorage
            this.executionStoppedAt = x.executionStoppedAt
            this.fargateEphemeralStorage = x.fargateEphemeralStorage
            this.group = x.group
            this.healthStatus = x.healthStatus
            this.inferenceAccelerators = x.inferenceAccelerators
            this.lastStatus = x.lastStatus
            this.launchType = x.launchType
            this.memory = x.memory
            this.overrides = x.overrides
            this.platformFamily = x.platformFamily
            this.platformVersion = x.platformVersion
            this.pullStartedAt = x.pullStartedAt
            this.pullStoppedAt = x.pullStoppedAt
            this.startedAt = x.startedAt
            this.startedBy = x.startedBy
            this.stopCode = x.stopCode
            this.stoppedAt = x.stoppedAt
            this.stoppedReason = x.stoppedReason
            this.stoppingAt = x.stoppingAt
            this.tags = x.tags
            this.taskArn = x.taskArn
            this.taskDefinitionArn = x.taskDefinitionArn
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Task = Task(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.ecs.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.ecs.model.EphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.TaskEphemeralStorage] inside the given [block]
         */
        public fun fargateEphemeralStorage(block: aws.sdk.kotlin.services.ecs.model.TaskEphemeralStorage.Builder.() -> kotlin.Unit) {
            this.fargateEphemeralStorage = aws.sdk.kotlin.services.ecs.model.TaskEphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.TaskOverride] inside the given [block]
         */
        public fun overrides(block: aws.sdk.kotlin.services.ecs.model.TaskOverride.Builder.() -> kotlin.Unit) {
            this.overrides = aws.sdk.kotlin.services.ecs.model.TaskOverride.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
