// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.paginators

import aws.sdk.kotlin.services.ecs.EcsClient
import aws.sdk.kotlin.services.ecs.model.Attribute
import aws.sdk.kotlin.services.ecs.model.ListAccountSettingsRequest
import aws.sdk.kotlin.services.ecs.model.ListAccountSettingsResponse
import aws.sdk.kotlin.services.ecs.model.ListAttributesRequest
import aws.sdk.kotlin.services.ecs.model.ListAttributesResponse
import aws.sdk.kotlin.services.ecs.model.ListClustersRequest
import aws.sdk.kotlin.services.ecs.model.ListClustersResponse
import aws.sdk.kotlin.services.ecs.model.ListContainerInstancesRequest
import aws.sdk.kotlin.services.ecs.model.ListContainerInstancesResponse
import aws.sdk.kotlin.services.ecs.model.ListServicesByNamespaceRequest
import aws.sdk.kotlin.services.ecs.model.ListServicesByNamespaceResponse
import aws.sdk.kotlin.services.ecs.model.ListServicesRequest
import aws.sdk.kotlin.services.ecs.model.ListServicesResponse
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionFamiliesRequest
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionFamiliesResponse
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionsRequest
import aws.sdk.kotlin.services.ecs.model.ListTaskDefinitionsResponse
import aws.sdk.kotlin.services.ecs.model.ListTasksRequest
import aws.sdk.kotlin.services.ecs.model.ListTasksResponse
import aws.sdk.kotlin.services.ecs.model.Setting
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccountSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountSettingsResponse]
 */
public fun EcsClient.listAccountSettingsPaginated(initialRequest: ListAccountSettingsRequest = ListAccountSettingsRequest { }): Flow<ListAccountSettingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountSettingsPaginated.listAccountSettings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountSettingsResponse]
 */
public fun EcsClient.listAccountSettingsPaginated(block: ListAccountSettingsRequest.Builder.() -> Unit): Flow<ListAccountSettingsResponse> =
    listAccountSettingsPaginated(ListAccountSettingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccountSettingsPaginated]
 * to access the nested member [Setting]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Setting]
 */
@JvmName("listAccountSettingsResponseSetting")
public fun Flow<ListAccountSettingsResponse>.settings(): Flow<Setting> =
    transform() { response ->
        response.settings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttributesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttributesResponse]
 */
public fun EcsClient.listAttributesPaginated(initialRequest: ListAttributesRequest): Flow<ListAttributesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAttributesPaginated.listAttributes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAttributesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttributesResponse]
 */
public fun EcsClient.listAttributesPaginated(block: ListAttributesRequest.Builder.() -> Unit): Flow<ListAttributesResponse> =
    listAttributesPaginated(ListAttributesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttributesPaginated]
 * to access the nested member [Attribute]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Attribute]
 */
@JvmName("listAttributesResponseAttribute")
public fun Flow<ListAttributesResponse>.attributes(): Flow<Attribute> =
    transform() { response ->
        response.attributes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun EcsClient.listClustersPaginated(initialRequest: ListClustersRequest = ListClustersRequest { }): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun EcsClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listClustersResponseString")
public fun Flow<ListClustersResponse>.clusterArns(): Flow<String> =
    transform() { response ->
        response.clusterArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContainerInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContainerInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContainerInstancesResponse]
 */
public fun EcsClient.listContainerInstancesPaginated(initialRequest: ListContainerInstancesRequest = ListContainerInstancesRequest { }): Flow<ListContainerInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContainerInstancesPaginated.listContainerInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListContainerInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContainerInstancesResponse]
 */
public fun EcsClient.listContainerInstancesPaginated(block: ListContainerInstancesRequest.Builder.() -> Unit): Flow<ListContainerInstancesResponse> =
    listContainerInstancesPaginated(ListContainerInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContainerInstancesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listContainerInstancesResponseString")
public fun Flow<ListContainerInstancesResponse>.containerInstanceArns(): Flow<String> =
    transform() { response ->
        response.containerInstanceArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun EcsClient.listServicesPaginated(initialRequest: ListServicesRequest = ListServicesRequest { }): Flow<ListServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesPaginated.listServices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun EcsClient.listServicesPaginated(block: ListServicesRequest.Builder.() -> Unit): Flow<ListServicesResponse> =
    listServicesPaginated(ListServicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServicesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listServicesResponseString")
public fun Flow<ListServicesResponse>.serviceArns(): Flow<String> =
    transform() { response ->
        response.serviceArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServicesByNamespaceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesByNamespaceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesByNamespaceResponse]
 */
public fun EcsClient.listServicesByNamespacePaginated(initialRequest: ListServicesByNamespaceRequest): Flow<ListServicesByNamespaceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesByNamespacePaginated.listServicesByNamespace(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesByNamespaceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesByNamespaceResponse]
 */
public fun EcsClient.listServicesByNamespacePaginated(block: ListServicesByNamespaceRequest.Builder.() -> Unit): Flow<ListServicesByNamespaceResponse> =
    listServicesByNamespacePaginated(ListServicesByNamespaceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServicesByNamespacePaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listServicesByNamespaceResponseString")
public fun Flow<ListServicesByNamespaceResponse>.serviceArns(): Flow<String> =
    transform() { response ->
        response.serviceArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaskDefinitionFamiliesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaskDefinitionFamiliesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskDefinitionFamiliesResponse]
 */
public fun EcsClient.listTaskDefinitionFamiliesPaginated(initialRequest: ListTaskDefinitionFamiliesRequest = ListTaskDefinitionFamiliesRequest { }): Flow<ListTaskDefinitionFamiliesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaskDefinitionFamiliesPaginated.listTaskDefinitionFamilies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTaskDefinitionFamiliesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskDefinitionFamiliesResponse]
 */
public fun EcsClient.listTaskDefinitionFamiliesPaginated(block: ListTaskDefinitionFamiliesRequest.Builder.() -> Unit): Flow<ListTaskDefinitionFamiliesResponse> =
    listTaskDefinitionFamiliesPaginated(ListTaskDefinitionFamiliesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaskDefinitionFamiliesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listTaskDefinitionFamiliesResponseString")
public fun Flow<ListTaskDefinitionFamiliesResponse>.families(): Flow<String> =
    transform() { response ->
        response.families?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaskDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaskDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskDefinitionsResponse]
 */
public fun EcsClient.listTaskDefinitionsPaginated(initialRequest: ListTaskDefinitionsRequest = ListTaskDefinitionsRequest { }): Flow<ListTaskDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaskDefinitionsPaginated.listTaskDefinitions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTaskDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskDefinitionsResponse]
 */
public fun EcsClient.listTaskDefinitionsPaginated(block: ListTaskDefinitionsRequest.Builder.() -> Unit): Flow<ListTaskDefinitionsResponse> =
    listTaskDefinitionsPaginated(ListTaskDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaskDefinitionsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listTaskDefinitionsResponseString")
public fun Flow<ListTaskDefinitionsResponse>.taskDefinitionArns(): Flow<String> =
    transform() { response ->
        response.taskDefinitionArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTasksResponse]
 */
public fun EcsClient.listTasksPaginated(initialRequest: ListTasksRequest = ListTasksRequest { }): Flow<ListTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTasksPaginated.listTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTasksResponse]
 */
public fun EcsClient.listTasksPaginated(block: ListTasksRequest.Builder.() -> Unit): Flow<ListTasksResponse> =
    listTasksPaginated(ListTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTasksPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listTasksResponseString")
public fun Flow<ListTasksResponse>.taskArns(): Flow<String> =
    transform() { response ->
        response.taskArns?.forEach {
            emit(it)
        }
    }
