// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The `ulimit` settings to pass to the container.
 *
 * Amazon ECS tasks hosted on Fargate use the default resource limit values set by the operating system with the exception of the `nofile` resource limit parameter which Fargate overrides. The `nofile` resource limit sets a restriction on the number of open files that a container can use. The default `nofile` soft limit is `1024` and the default hard limit is `65535`.
 *
 * You can specify the `ulimit` settings for a container in a task definition.
 */
public class Ulimit private constructor(builder: Builder) {
    /**
     * The hard limit for the `ulimit` type.
     */
    public val hardLimit: kotlin.Int = builder.hardLimit
    /**
     * The `type` of the `ulimit`.
     */
    public val name: aws.sdk.kotlin.services.ecs.model.UlimitName = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The soft limit for the `ulimit` type.
     */
    public val softLimit: kotlin.Int = builder.softLimit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Ulimit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ulimit(")
        append("hardLimit=$hardLimit,")
        append("name=$name,")
        append("softLimit=$softLimit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hardLimit
        result = 31 * result + (name.hashCode())
        result = 31 * result + (softLimit)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ulimit

        if (hardLimit != other.hardLimit) return false
        if (name != other.name) return false
        if (softLimit != other.softLimit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Ulimit = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The hard limit for the `ulimit` type.
         */
        public var hardLimit: kotlin.Int = 0
        /**
         * The `type` of the `ulimit`.
         */
        public var name: aws.sdk.kotlin.services.ecs.model.UlimitName? = null
        /**
         * The soft limit for the `ulimit` type.
         */
        public var softLimit: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Ulimit) : this() {
            this.hardLimit = x.hardLimit
            this.name = x.name
            this.softLimit = x.softLimit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Ulimit = Ulimit(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = UlimitName.SdkUnknown("no value provided")
            return this
        }
    }
}
