// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Service Connect service object configuration. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class ServiceConnectService private constructor(builder: Builder) {
    /**
     * The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
     *
     * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
     *
     * Each name and port mapping must be unique within the namespace.
     *
     * For each `ServiceConnectService`, you must provide at least one `clientAlias` with one `port`.
     */
    public val clientAliases: List<ServiceConnectClientAlias>? = builder.clientAliases
    /**
     * The `discoveryName` is the name of the new Cloud Map service that Amazon ECS creates for this Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
     *
     * If the `discoveryName` isn't specified, the port mapping name from the task definition is used in `portName.namespace`.
     */
    public val discoveryName: kotlin.String? = builder.discoveryName
    /**
     * The port number for the Service Connect proxy to listen on.
     *
     * Use the value of this field to bypass the proxy for traffic on the port number specified in the named `portMapping` in the task definition of this application, and then use it in your VPC security groups to allow traffic into the proxy for this Amazon ECS service.
     *
     * In `awsvpc` mode and Fargate, the default value is the container port number. The container port number is in the `portMapping` in the task definition. In bridge mode, the default value is the ephemeral port of the Service Connect proxy.
     */
    public val ingressPortOverride: kotlin.Int? = builder.ingressPortOverride
    /**
     * The `portName` must match the name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
     */
    public val portName: kotlin.String = requireNotNull(builder.portName) { "A non-null value must be provided for portName" }
    /**
     * A reference to an object that represents the configured timeouts for Service Connect.
     */
    public val timeout: aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration? = builder.timeout
    /**
     * A reference to an object that represents a Transport Layer Security (TLS) configuration.
     */
    public val tls: aws.sdk.kotlin.services.ecs.model.ServiceConnectTlsConfiguration? = builder.tls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ServiceConnectService = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceConnectService(")
        append("clientAliases=$clientAliases,")
        append("discoveryName=$discoveryName,")
        append("ingressPortOverride=$ingressPortOverride,")
        append("portName=$portName,")
        append("timeout=$timeout,")
        append("tls=$tls")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientAliases?.hashCode() ?: 0
        result = 31 * result + (discoveryName?.hashCode() ?: 0)
        result = 31 * result + (ingressPortOverride ?: 0)
        result = 31 * result + (portName.hashCode())
        result = 31 * result + (timeout?.hashCode() ?: 0)
        result = 31 * result + (tls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceConnectService

        if (clientAliases != other.clientAliases) return false
        if (discoveryName != other.discoveryName) return false
        if (ingressPortOverride != other.ingressPortOverride) return false
        if (portName != other.portName) return false
        if (timeout != other.timeout) return false
        if (tls != other.tls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ServiceConnectService = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
         *
         * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
         *
         * Each name and port mapping must be unique within the namespace.
         *
         * For each `ServiceConnectService`, you must provide at least one `clientAlias` with one `port`.
         */
        public var clientAliases: List<ServiceConnectClientAlias>? = null
        /**
         * The `discoveryName` is the name of the new Cloud Map service that Amazon ECS creates for this Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
         *
         * If the `discoveryName` isn't specified, the port mapping name from the task definition is used in `portName.namespace`.
         */
        public var discoveryName: kotlin.String? = null
        /**
         * The port number for the Service Connect proxy to listen on.
         *
         * Use the value of this field to bypass the proxy for traffic on the port number specified in the named `portMapping` in the task definition of this application, and then use it in your VPC security groups to allow traffic into the proxy for this Amazon ECS service.
         *
         * In `awsvpc` mode and Fargate, the default value is the container port number. The container port number is in the `portMapping` in the task definition. In bridge mode, the default value is the ephemeral port of the Service Connect proxy.
         */
        public var ingressPortOverride: kotlin.Int? = null
        /**
         * The `portName` must match the name of one of the `portMappings` from all the containers in the task definition of this Amazon ECS service.
         */
        public var portName: kotlin.String? = null
        /**
         * A reference to an object that represents the configured timeouts for Service Connect.
         */
        public var timeout: aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration? = null
        /**
         * A reference to an object that represents a Transport Layer Security (TLS) configuration.
         */
        public var tls: aws.sdk.kotlin.services.ecs.model.ServiceConnectTlsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ServiceConnectService) : this() {
            this.clientAliases = x.clientAliases
            this.discoveryName = x.discoveryName
            this.ingressPortOverride = x.ingressPortOverride
            this.portName = x.portName
            this.timeout = x.timeout
            this.tls = x.tls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ServiceConnectService = ServiceConnectService(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration] inside the given [block]
         */
        public fun timeout(block: aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration.Builder.() -> kotlin.Unit) {
            this.timeout = aws.sdk.kotlin.services.ecs.model.TimeoutConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ServiceConnectTlsConfiguration] inside the given [block]
         */
        public fun tls(block: aws.sdk.kotlin.services.ecs.model.ServiceConnectTlsConfiguration.Builder.() -> kotlin.Unit) {
            this.tls = aws.sdk.kotlin.services.ecs.model.ServiceConnectTlsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (portName == null) portName = ""
            return this
        }
    }
}
