// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RegisterTaskDefinitionRequest private constructor(builder: Builder) {
    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     */
    public val containerDefinitions: List<ContainerDefinition>? = builder.containerDefinitions
    /**
     * The number of CPU units used by the task. It can be expressed as an integer using CPU units (for example, `1024`) or as a string using vCPUs (for example, `1 vCPU` or `1 vcpu`) in a task definition. String values are converted to an integer indicating the CPU units when the task definition is registered.
     *
     * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.
     *
     * If you're using the EC2 launch type, this field is optional. Supported values are between `128` CPU units (`0.125` vCPUs) and `10240` CPU units (`10` vCPUs). If you do not specify a value, the parameter is ignored.
     *
     * If you're using the Fargate launch type, this field is required and you must use one of the following values, which determines your range of supported values for the `memory` parameter:
     *
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * + 256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * + 512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * + 1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     * + 2048 (2 vCPU) - Available `memory` values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * + 4096 (4 vCPU) - Available `memory` values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * + 8192 (8 vCPU) - Available `memory` values: 16 GB and 60 GB in 4 GB incrementsThis option requires Linux platform `1.4.0` or later.
     * + 16384 (16vCPU) - Available `memory` values: 32GB and 120 GB in 8 GB incrementsThis option requires Linux platform `1.4.0` or later.
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon ECS Developer Guide*.
     *
     * For tasks using the Fargate launch type, the task requires the following platforms:
     * + Linux platform version `1.4.0` or later.
     * + Windows platform version `1.0.0` or later.
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * You must specify a `family` for a task definition. You can use it track multiple versions of the same task definition. The `family` is used as a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
     */
    public val family: kotlin.String? = builder.family
    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    public val inferenceAccelerators: List<InferenceAccelerator>? = builder.inferenceAccelerators
    /**
     * The IPC resource namespace to use for the containers in the task. The valid values are `host`, `task`, or `none`. If `host` is specified, then all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If `task` is specified, all containers within the specified task share the same IPC resources. If `none` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the *Docker run reference*.
     *
     * If the `host` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
     *
     * If you are setting namespaced kernel parameters using `systemControls` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
     * + For tasks that use the `host` IPC mode, IPC namespace related `systemControls` are not supported.
     * + For tasks that use the `task` IPC mode, IPC namespace related `systemControls` will apply to all containers within a task.
     *
     * This parameter is not supported for Windows containers or tasks run on Fargate.
     */
    public val ipcMode: aws.sdk.kotlin.services.ecs.model.IpcMode? = builder.ipcMode
    /**
     * The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB (for example ,`1024`) or as a string using GB (for example, `1GB` or `1 GB`) in a task definition. String values are converted to an integer indicating the MiB when the task definition is registered.
     *
     * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.
     *
     * If using the EC2 launch type, this field is optional.
     *
     * If using the Fargate launch type, this field is required and you must use one of the following values. This determines your range of supported values for the `cpu` parameter.
     *
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * + 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256 (.25 vCPU)
     * + 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu` values: 512 (.5 vCPU)
     * + 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
     * + Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available `cpu` values: 2048 (2 vCPU)
     * + Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available `cpu` values: 4096 (4 vCPU)
     * + Between 16 GB and 60 GB in 4 GB increments - Available `cpu` values: 8192 (8 vCPU)This option requires Linux platform `1.4.0` or later.
     * + Between 32GB and 120 GB in 8 GB increments - Available `cpu` values: 16384 (16 vCPU)This option requires Linux platform `1.4.0` or later.
     */
    public val memory: kotlin.String? = builder.memory
    /**
     * The Docker networking mode to use for the containers in the task. The valid values are `none`, `bridge`, `awsvpc`, and `host`. If no network mode is specified, the default is `bridge`.
     *
     * For Amazon ECS tasks on Fargate, the `awsvpc` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, `<default>` or `awsvpc` can be used. If the network mode is set to `none`, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The `host` and `awsvpc` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the `bridge` mode.
     *
     * With the `host` and `awsvpc` network modes, exposed container ports are mapped directly to the corresponding host port (for the `host` network mode) or the attached elastic network interface port (for the `awsvpc` network mode), so you cannot take advantage of dynamic host port mappings.
     *
     * When using the `host` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
     *
     * If the network mode is `awsvpc`, the task is allocated an elastic network interface, and you must specify a NetworkConfiguration value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If the network mode is `host`, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
     *
     * For more information, see [Network settings](https://docs.docker.com/engine/reference/run/#network-settings) in the *Docker run reference*.
     */
    public val networkMode: aws.sdk.kotlin.services.ecs.model.NetworkMode? = builder.networkMode
    /**
     * The process namespace to use for the containers in the task. The valid values are `host` or `task`. On Fargate for Linux containers, the only valid value is `task`. For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
     *
     * If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
     *
     * If `task` is specified, all containers within the specified task share the same process namespace.
     *
     * If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the *Docker run reference*.
     *
     * If the `host` PID mode is used, there's a heightened risk of undesired process namespace exposure. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
     *
     * This parameter is not supported for Windows containers.
     *
     * This parameter is only supported for tasks that are hosted on Fargate if the tasks are using platform version `1.4.0` or later (Linux). This isn't supported for Windows containers on Fargate.
     */
    public val pidMode: aws.sdk.kotlin.services.ecs.model.PidMode? = builder.pidMode
    /**
     * An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     */
    public val placementConstraints: List<TaskDefinitionPlacementConstraint>? = builder.placementConstraints
    /**
     * The configuration details for the App Mesh proxy.
     *
     * For tasks hosted on Amazon EC2 instances, the container instances require at least version `1.26.0` of the container agent and at least version `1.26.0-1` of the `ecs-init` package to use a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized AMI versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val proxyConfiguration: aws.sdk.kotlin.services.ecs.model.ProxyConfiguration? = builder.proxyConfiguration
    /**
     * The task launch type that Amazon ECS validates the task definition against. A client exception is returned if the task definition doesn't validate against the compatibilities specified. If no value is specified, the parameter is omitted from the response.
     */
    public val requiresCompatibilities: List<Compatibility>? = builder.requiresCompatibilities
    /**
     * The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type.
     *
     * When you specify a task definition in a service, this value must match the `runtimePlatform` value of the service.
     */
    public val runtimePlatform: aws.sdk.kotlin.services.ecs.model.RuntimePlatform? = builder.runtimePlatform
    /**
     * The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see [IAM Roles for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val taskRoleArn: kotlin.String? = builder.taskRoleArn
    /**
     * A list of volume definitions in JSON format that containers in your task might use.
     */
    public val volumes: List<Volume>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.RegisterTaskDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterTaskDefinitionRequest(")
        append("containerDefinitions=$containerDefinitions,")
        append("cpu=$cpu,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("executionRoleArn=$executionRoleArn,")
        append("family=$family,")
        append("inferenceAccelerators=$inferenceAccelerators,")
        append("ipcMode=$ipcMode,")
        append("memory=$memory,")
        append("networkMode=$networkMode,")
        append("pidMode=$pidMode,")
        append("placementConstraints=$placementConstraints,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("requiresCompatibilities=$requiresCompatibilities,")
        append("runtimePlatform=$runtimePlatform,")
        append("tags=$tags,")
        append("taskRoleArn=$taskRoleArn,")
        append("volumes=$volumes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerDefinitions?.hashCode() ?: 0
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (family?.hashCode() ?: 0)
        result = 31 * result + (inferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (ipcMode?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (networkMode?.hashCode() ?: 0)
        result = 31 * result + (pidMode?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requiresCompatibilities?.hashCode() ?: 0)
        result = 31 * result + (runtimePlatform?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskRoleArn?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterTaskDefinitionRequest

        if (containerDefinitions != other.containerDefinitions) return false
        if (cpu != other.cpu) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (family != other.family) return false
        if (inferenceAccelerators != other.inferenceAccelerators) return false
        if (ipcMode != other.ipcMode) return false
        if (memory != other.memory) return false
        if (networkMode != other.networkMode) return false
        if (pidMode != other.pidMode) return false
        if (placementConstraints != other.placementConstraints) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (requiresCompatibilities != other.requiresCompatibilities) return false
        if (runtimePlatform != other.runtimePlatform) return false
        if (tags != other.tags) return false
        if (taskRoleArn != other.taskRoleArn) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.RegisterTaskDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of container definitions in JSON format that describe the different containers that make up your task.
         */
        public var containerDefinitions: List<ContainerDefinition>? = null
        /**
         * The number of CPU units used by the task. It can be expressed as an integer using CPU units (for example, `1024`) or as a string using vCPUs (for example, `1 vCPU` or `1 vcpu`) in a task definition. String values are converted to an integer indicating the CPU units when the task definition is registered.
         *
         * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.
         *
         * If you're using the EC2 launch type, this field is optional. Supported values are between `128` CPU units (`0.125` vCPUs) and `10240` CPU units (`10` vCPUs). If you do not specify a value, the parameter is ignored.
         *
         * If you're using the Fargate launch type, this field is required and you must use one of the following values, which determines your range of supported values for the `memory` parameter:
         *
         * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         * + 256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * + 512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * + 1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * + 2048 (2 vCPU) - Available `memory` values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         * + 4096 (4 vCPU) - Available `memory` values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * + 8192 (8 vCPU) - Available `memory` values: 16 GB and 60 GB in 4 GB incrementsThis option requires Linux platform `1.4.0` or later.
         * + 16384 (16vCPU) - Available `memory` values: 32GB and 120 GB in 8 GB incrementsThis option requires Linux platform `1.4.0` or later.
         */
        public var cpu: kotlin.String? = null
        /**
         * The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon ECS Developer Guide*.
         *
         * For tasks using the Fargate launch type, the task requires the following platforms:
         * + Linux platform version `1.4.0` or later.
         * + Windows platform version `1.0.0` or later.
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = null
        /**
         * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * You must specify a `family` for a task definition. You can use it track multiple versions of the same task definition. The `family` is used as a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
         */
        public var family: kotlin.String? = null
        /**
         * The Elastic Inference accelerators to use for the containers in the task.
         */
        public var inferenceAccelerators: List<InferenceAccelerator>? = null
        /**
         * The IPC resource namespace to use for the containers in the task. The valid values are `host`, `task`, or `none`. If `host` is specified, then all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If `task` is specified, all containers within the specified task share the same IPC resources. If `none` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the *Docker run reference*.
         *
         * If the `host` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
         *
         * If you are setting namespaced kernel parameters using `systemControls` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
         * + For tasks that use the `host` IPC mode, IPC namespace related `systemControls` are not supported.
         * + For tasks that use the `task` IPC mode, IPC namespace related `systemControls` will apply to all containers within a task.
         *
         * This parameter is not supported for Windows containers or tasks run on Fargate.
         */
        public var ipcMode: aws.sdk.kotlin.services.ecs.model.IpcMode? = null
        /**
         * The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB (for example ,`1024`) or as a string using GB (for example, `1GB` or `1 GB`) in a task definition. String values are converted to an integer indicating the MiB when the task definition is registered.
         *
         * Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.
         *
         * If using the EC2 launch type, this field is optional.
         *
         * If using the Fargate launch type, this field is required and you must use one of the following values. This determines your range of supported values for the `cpu` parameter.
         *
         * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         * + 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256 (.25 vCPU)
         * + 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu` values: 512 (.5 vCPU)
         * + 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
         * + Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available `cpu` values: 2048 (2 vCPU)
         * + Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available `cpu` values: 4096 (4 vCPU)
         * + Between 16 GB and 60 GB in 4 GB increments - Available `cpu` values: 8192 (8 vCPU)This option requires Linux platform `1.4.0` or later.
         * + Between 32GB and 120 GB in 8 GB increments - Available `cpu` values: 16384 (16 vCPU)This option requires Linux platform `1.4.0` or later.
         */
        public var memory: kotlin.String? = null
        /**
         * The Docker networking mode to use for the containers in the task. The valid values are `none`, `bridge`, `awsvpc`, and `host`. If no network mode is specified, the default is `bridge`.
         *
         * For Amazon ECS tasks on Fargate, the `awsvpc` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, `<default>` or `awsvpc` can be used. If the network mode is set to `none`, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The `host` and `awsvpc` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the `bridge` mode.
         *
         * With the `host` and `awsvpc` network modes, exposed container ports are mapped directly to the corresponding host port (for the `host` network mode) or the attached elastic network interface port (for the `awsvpc` network mode), so you cannot take advantage of dynamic host port mappings.
         *
         * When using the `host` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
         *
         * If the network mode is `awsvpc`, the task is allocated an elastic network interface, and you must specify a NetworkConfiguration value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If the network mode is `host`, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
         *
         * For more information, see [Network settings](https://docs.docker.com/engine/reference/run/#network-settings) in the *Docker run reference*.
         */
        public var networkMode: aws.sdk.kotlin.services.ecs.model.NetworkMode? = null
        /**
         * The process namespace to use for the containers in the task. The valid values are `host` or `task`. On Fargate for Linux containers, the only valid value is `task`. For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
         *
         * If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
         *
         * If `task` is specified, all containers within the specified task share the same process namespace.
         *
         * If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the *Docker run reference*.
         *
         * If the `host` PID mode is used, there's a heightened risk of undesired process namespace exposure. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
         *
         * This parameter is not supported for Windows containers.
         *
         * This parameter is only supported for tasks that are hosted on Fargate if the tasks are using platform version `1.4.0` or later (Linux). This isn't supported for Windows containers on Fargate.
         */
        public var pidMode: aws.sdk.kotlin.services.ecs.model.PidMode? = null
        /**
         * An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         */
        public var placementConstraints: List<TaskDefinitionPlacementConstraint>? = null
        /**
         * The configuration details for the App Mesh proxy.
         *
         * For tasks hosted on Amazon EC2 instances, the container instances require at least version `1.26.0` of the container agent and at least version `1.26.0-1` of the `ecs-init` package to use a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version `20190301` or later, then they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized AMI versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var proxyConfiguration: aws.sdk.kotlin.services.ecs.model.ProxyConfiguration? = null
        /**
         * The task launch type that Amazon ECS validates the task definition against. A client exception is returned if the task definition doesn't validate against the compatibilities specified. If no value is specified, the parameter is omitted from the response.
         */
        public var requiresCompatibilities: List<Compatibility>? = null
        /**
         * The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type.
         *
         * When you specify a task definition in a service, this value must match the `runtimePlatform` value of the service.
         */
        public var runtimePlatform: aws.sdk.kotlin.services.ecs.model.RuntimePlatform? = null
        /**
         * The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see [IAM Roles for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var taskRoleArn: kotlin.String? = null
        /**
         * A list of volume definitions in JSON format that containers in your task might use.
         */
        public var volumes: List<Volume>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.RegisterTaskDefinitionRequest) : this() {
            this.containerDefinitions = x.containerDefinitions
            this.cpu = x.cpu
            this.ephemeralStorage = x.ephemeralStorage
            this.executionRoleArn = x.executionRoleArn
            this.family = x.family
            this.inferenceAccelerators = x.inferenceAccelerators
            this.ipcMode = x.ipcMode
            this.memory = x.memory
            this.networkMode = x.networkMode
            this.pidMode = x.pidMode
            this.placementConstraints = x.placementConstraints
            this.proxyConfiguration = x.proxyConfiguration
            this.requiresCompatibilities = x.requiresCompatibilities
            this.runtimePlatform = x.runtimePlatform
            this.tags = x.tags
            this.taskRoleArn = x.taskRoleArn
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.RegisterTaskDefinitionRequest = RegisterTaskDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.ecs.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.ecs.model.EphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ProxyConfiguration] inside the given [block]
         */
        public fun proxyConfiguration(block: aws.sdk.kotlin.services.ecs.model.ProxyConfiguration.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.ecs.model.ProxyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.RuntimePlatform] inside the given [block]
         */
        public fun runtimePlatform(block: aws.sdk.kotlin.services.ecs.model.RuntimePlatform.Builder.() -> kotlin.Unit) {
            this.runtimePlatform = aws.sdk.kotlin.services.ecs.model.RuntimePlatform.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
