// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The managed scaling settings for the Auto Scaling group capacity provider.
 *
 * When managed scaling is turned on, Amazon ECS manages the scale-in and scale-out actions of the Auto Scaling group. Amazon ECS manages a target tracking scaling policy using an Amazon ECS managed CloudWatch metric with the specified `targetCapacity` value as the target value for the metric. For more information, see [Using managed scaling](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling) in the *Amazon Elastic Container Service Developer Guide*.
 *
 * If managed scaling is off, the user must manage the scaling of the Auto Scaling group.
 */
public class ManagedScaling private constructor(builder: Builder) {
    /**
     * The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of `300` seconds is used.
     */
    public val instanceWarmupPeriod: kotlin.Int? = builder.instanceWarmupPeriod
    /**
     * The maximum number of Amazon EC2 instances that Amazon ECS will scale out at one time. The scale in process is not affected by this parameter. If this parameter is omitted, the default value of `10000` is used.
     */
    public val maximumScalingStepSize: kotlin.Int? = builder.maximumScalingStepSize
    /**
     * The minimum number of Amazon EC2 instances that Amazon ECS will scale out at one time. The scale in process is not affected by this parameter If this parameter is omitted, the default value of `1` is used.
     *
     * When additional capacity is required, Amazon ECS will scale up the minimum scaling step size even if the actual demand is less than the minimum scaling step size.
     *
     * If you use a capacity provider with an Auto Scaling group configured with more than one Amazon EC2 instance type or Availability Zone, Amazon ECS will scale up by the exact minimum scaling step size value and will ignore both the maximum scaling step size as well as the capacity demand.
     */
    public val minimumScalingStepSize: kotlin.Int? = builder.minimumScalingStepSize
    /**
     * Determines whether to use managed scaling for the capacity provider.
     */
    public val status: aws.sdk.kotlin.services.ecs.model.ManagedScalingStatus? = builder.status
    /**
     * The target capacity utilization as a percentage for the capacity provider. The specified value must be greater than `0` and less than or equal to `100`. For example, if you want the capacity provider to maintain 10% spare capacity, then that means the utilization is 90%, so use a `targetCapacity` of `90`. The default value of `100` percent results in the Amazon EC2 instances in your Auto Scaling group being completely used.
     */
    public val targetCapacity: kotlin.Int? = builder.targetCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ManagedScaling = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedScaling(")
        append("instanceWarmupPeriod=$instanceWarmupPeriod,")
        append("maximumScalingStepSize=$maximumScalingStepSize,")
        append("minimumScalingStepSize=$minimumScalingStepSize,")
        append("status=$status,")
        append("targetCapacity=$targetCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceWarmupPeriod ?: 0
        result = 31 * result + (maximumScalingStepSize ?: 0)
        result = 31 * result + (minimumScalingStepSize ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedScaling

        if (instanceWarmupPeriod != other.instanceWarmupPeriod) return false
        if (maximumScalingStepSize != other.maximumScalingStepSize) return false
        if (minimumScalingStepSize != other.minimumScalingStepSize) return false
        if (status != other.status) return false
        if (targetCapacity != other.targetCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ManagedScaling = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of `300` seconds is used.
         */
        public var instanceWarmupPeriod: kotlin.Int? = null
        /**
         * The maximum number of Amazon EC2 instances that Amazon ECS will scale out at one time. The scale in process is not affected by this parameter. If this parameter is omitted, the default value of `10000` is used.
         */
        public var maximumScalingStepSize: kotlin.Int? = null
        /**
         * The minimum number of Amazon EC2 instances that Amazon ECS will scale out at one time. The scale in process is not affected by this parameter If this parameter is omitted, the default value of `1` is used.
         *
         * When additional capacity is required, Amazon ECS will scale up the minimum scaling step size even if the actual demand is less than the minimum scaling step size.
         *
         * If you use a capacity provider with an Auto Scaling group configured with more than one Amazon EC2 instance type or Availability Zone, Amazon ECS will scale up by the exact minimum scaling step size value and will ignore both the maximum scaling step size as well as the capacity demand.
         */
        public var minimumScalingStepSize: kotlin.Int? = null
        /**
         * Determines whether to use managed scaling for the capacity provider.
         */
        public var status: aws.sdk.kotlin.services.ecs.model.ManagedScalingStatus? = null
        /**
         * The target capacity utilization as a percentage for the capacity provider. The specified value must be greater than `0` and less than or equal to `100`. For example, if you want the capacity provider to maintain 10% spare capacity, then that means the utilization is 90%, so use a `targetCapacity` of `90`. The default value of `100` percent results in the Amazon EC2 instances in your Auto Scaling group being completely used.
         */
        public var targetCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ManagedScaling) : this() {
            this.instanceWarmupPeriod = x.instanceWarmupPeriod
            this.maximumScalingStepSize = x.maximumScalingStepSize
            this.minimumScalingStepSize = x.minimumScalingStepSize
            this.status = x.status
            this.targetCapacity = x.targetCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ManagedScaling = ManagedScaling(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
