// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of an Amazon ECS service deployment. This is used only when a service uses the `ECS` deployment controller type.
 */
public class Deployment private constructor(builder: Builder) {
    /**
     * The capacity provider strategy that the deployment is using.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * The Unix timestamp for the time when the service deployment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The most recent desired count of tasks that was specified for the service to deploy or maintain.
     */
    public val desiredCount: kotlin.Int = builder.desiredCount
    /**
     * The number of consecutively failed tasks in the deployment. A task is considered a failure if the service scheduler can't launch the task, the task doesn't transition to a `RUNNING` state, or if it fails any of its defined health checks and is stopped.
     *
     * Once a service deployment has one or more successfully running tasks, the failed task count resets to zero and stops being evaluated.
     */
    public val failedTasks: kotlin.Int = builder.failedTasks
    /**
     * The ID of the deployment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The launch type the tasks in the service are using. For more information, see [Amazon ECS Launch Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the `awsvpc` networking mode.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The number of tasks in the deployment that are in the `PENDING` status.
     */
    public val pendingCount: kotlin.Int = builder.pendingCount
    /**
     * The operating system that your tasks in the service, or tasks are running on. A platform family is specified only for tasks using the Fargate launch type.
     *
     *  All tasks that run as part of this service must use the same `platformFamily` value as the service, for example, ` LINUX.`.
     */
    public val platformFamily: kotlin.String? = builder.platformFamily
    /**
     * The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The `rolloutState` of a service is only returned for services that use the rolling update (`ECS`) deployment type that aren't behind a Classic Load Balancer.
     *
     * The rollout state of the deployment. When a service deployment is started, it begins in an `IN_PROGRESS` state. When the service reaches a steady state, the deployment transitions to a `COMPLETED` state. If the service fails to reach a steady state and circuit breaker is turned on, the deployment transitions to a `FAILED` state. A deployment in `FAILED` state doesn't launch any new tasks. For more information, see DeploymentCircuitBreaker.
     */
    public val rolloutState: aws.sdk.kotlin.services.ecs.model.DeploymentRolloutState? = builder.rolloutState
    /**
     * A description of the rollout state of a deployment.
     */
    public val rolloutStateReason: kotlin.String? = builder.rolloutStateReason
    /**
     * The number of tasks in the deployment that are in the `RUNNING` status.
     */
    public val runningCount: kotlin.Int = builder.runningCount
    /**
     * The details of the Service Connect configuration that's used by this deployment. Compare the configuration between multiple deployments when troubleshooting issues with new deployments.
     *
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     *
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val serviceConnectConfiguration: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration? = builder.serviceConnectConfiguration
    /**
     * The list of Service Connect resources that are associated with this deployment. Each list entry maps a discovery name to a Cloud Map service name.
     */
    public val serviceConnectResources: List<ServiceConnectServiceResource>? = builder.serviceConnectResources
    /**
     * The status of the deployment. The following describes each state.
     *
     * ## PRIMARY
     * The most recent deployment of a service.
     *
     * ## ACTIVE
     * A service deployment that still has running tasks, but are in the process of being replaced with a new `PRIMARY` deployment.
     *
     * ## INACTIVE
     * A deployment that has been completely replaced.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The most recent task definition that was specified for the tasks in the service to use.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition
    /**
     * The Unix timestamp for the time when the service deployment was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The details of the volume that was `configuredAtLaunch`. You can configure different settings like the size, throughput, volumeType, and ecryption in [ServiceManagedEBSVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html). The `name` of the volume must match the `name` from the task definition.
     */
    public val volumeConfigurations: List<ServiceVolumeConfiguration>? = builder.volumeConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Deployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Deployment(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("createdAt=$createdAt,")
        append("desiredCount=$desiredCount,")
        append("failedTasks=$failedTasks,")
        append("id=$id,")
        append("launchType=$launchType,")
        append("networkConfiguration=$networkConfiguration,")
        append("pendingCount=$pendingCount,")
        append("platformFamily=$platformFamily,")
        append("platformVersion=$platformVersion,")
        append("rolloutState=$rolloutState,")
        append("rolloutStateReason=$rolloutStateReason,")
        append("runningCount=$runningCount,")
        append("serviceConnectConfiguration=$serviceConnectConfiguration,")
        append("serviceConnectResources=$serviceConnectResources,")
        append("status=$status,")
        append("taskDefinition=$taskDefinition,")
        append("updatedAt=$updatedAt,")
        append("volumeConfigurations=$volumeConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (desiredCount)
        result = 31 * result + (failedTasks)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pendingCount)
        result = 31 * result + (platformFamily?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (rolloutState?.hashCode() ?: 0)
        result = 31 * result + (rolloutStateReason?.hashCode() ?: 0)
        result = 31 * result + (runningCount)
        result = 31 * result + (serviceConnectConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceConnectResources?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (volumeConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Deployment

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (createdAt != other.createdAt) return false
        if (desiredCount != other.desiredCount) return false
        if (failedTasks != other.failedTasks) return false
        if (id != other.id) return false
        if (launchType != other.launchType) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pendingCount != other.pendingCount) return false
        if (platformFamily != other.platformFamily) return false
        if (platformVersion != other.platformVersion) return false
        if (rolloutState != other.rolloutState) return false
        if (rolloutStateReason != other.rolloutStateReason) return false
        if (runningCount != other.runningCount) return false
        if (serviceConnectConfiguration != other.serviceConnectConfiguration) return false
        if (serviceConnectResources != other.serviceConnectResources) return false
        if (status != other.status) return false
        if (taskDefinition != other.taskDefinition) return false
        if (updatedAt != other.updatedAt) return false
        if (volumeConfigurations != other.volumeConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Deployment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capacity provider strategy that the deployment is using.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * The Unix timestamp for the time when the service deployment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent desired count of tasks that was specified for the service to deploy or maintain.
         */
        public var desiredCount: kotlin.Int = 0
        /**
         * The number of consecutively failed tasks in the deployment. A task is considered a failure if the service scheduler can't launch the task, the task doesn't transition to a `RUNNING` state, or if it fails any of its defined health checks and is stopped.
         *
         * Once a service deployment has one or more successfully running tasks, the failed task count resets to zero and stops being evaluated.
         */
        public var failedTasks: kotlin.Int = 0
        /**
         * The ID of the deployment.
         */
        public var id: kotlin.String? = null
        /**
         * The launch type the tasks in the service are using. For more information, see [Amazon ECS Launch Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the `awsvpc` networking mode.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * The number of tasks in the deployment that are in the `PENDING` status.
         */
        public var pendingCount: kotlin.Int = 0
        /**
         * The operating system that your tasks in the service, or tasks are running on. A platform family is specified only for tasks using the Fargate launch type.
         *
         *  All tasks that run as part of this service must use the same `platformFamily` value as the service, for example, ` LINUX.`.
         */
        public var platformFamily: kotlin.String? = null
        /**
         * The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If one isn't specified, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The `rolloutState` of a service is only returned for services that use the rolling update (`ECS`) deployment type that aren't behind a Classic Load Balancer.
         *
         * The rollout state of the deployment. When a service deployment is started, it begins in an `IN_PROGRESS` state. When the service reaches a steady state, the deployment transitions to a `COMPLETED` state. If the service fails to reach a steady state and circuit breaker is turned on, the deployment transitions to a `FAILED` state. A deployment in `FAILED` state doesn't launch any new tasks. For more information, see DeploymentCircuitBreaker.
         */
        public var rolloutState: aws.sdk.kotlin.services.ecs.model.DeploymentRolloutState? = null
        /**
         * A description of the rollout state of a deployment.
         */
        public var rolloutStateReason: kotlin.String? = null
        /**
         * The number of tasks in the deployment that are in the `RUNNING` status.
         */
        public var runningCount: kotlin.Int = 0
        /**
         * The details of the Service Connect configuration that's used by this deployment. Compare the configuration between multiple deployments when troubleshooting issues with new deployments.
         *
         * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
         *
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var serviceConnectConfiguration: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration? = null
        /**
         * The list of Service Connect resources that are associated with this deployment. Each list entry maps a discovery name to a Cloud Map service name.
         */
        public var serviceConnectResources: List<ServiceConnectServiceResource>? = null
        /**
         * The status of the deployment. The following describes each state.
         *
         * ## PRIMARY
         * The most recent deployment of a service.
         *
         * ## ACTIVE
         * A service deployment that still has running tasks, but are in the process of being replaced with a new `PRIMARY` deployment.
         *
         * ## INACTIVE
         * A deployment that has been completely replaced.
         */
        public var status: kotlin.String? = null
        /**
         * The most recent task definition that was specified for the tasks in the service to use.
         */
        public var taskDefinition: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the service deployment was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The details of the volume that was `configuredAtLaunch`. You can configure different settings like the size, throughput, volumeType, and ecryption in [ServiceManagedEBSVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html). The `name` of the volume must match the `name` from the task definition.
         */
        public var volumeConfigurations: List<ServiceVolumeConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Deployment) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.createdAt = x.createdAt
            this.desiredCount = x.desiredCount
            this.failedTasks = x.failedTasks
            this.id = x.id
            this.launchType = x.launchType
            this.networkConfiguration = x.networkConfiguration
            this.pendingCount = x.pendingCount
            this.platformFamily = x.platformFamily
            this.platformVersion = x.platformVersion
            this.rolloutState = x.rolloutState
            this.rolloutStateReason = x.rolloutStateReason
            this.runningCount = x.runningCount
            this.serviceConnectConfiguration = x.serviceConnectConfiguration
            this.serviceConnectResources = x.serviceConnectResources
            this.status = x.status
            this.taskDefinition = x.taskDefinition
            this.updatedAt = x.updatedAt
            this.volumeConfigurations = x.volumeConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Deployment = Deployment(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration] inside the given [block]
         */
        public fun serviceConnectConfiguration(block: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration.Builder.() -> kotlin.Unit) {
            this.serviceConnectConfiguration = aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
