// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.ExecuteCommandRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ExecuteCommandOperationSerializer: HttpSerialize<ExecuteCommandRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ExecuteCommandRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeExecuteCommandOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeExecuteCommandOperationBody(context: ExecutionContext, input: ExecuteCommandRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cluster"))
    val COMMAND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("command"))
    val CONTAINER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("container"))
    val INTERACTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("interactive"))
    val TASK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("task"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTER_DESCRIPTOR)
        field(COMMAND_DESCRIPTOR)
        field(CONTAINER_DESCRIPTOR)
        field(INTERACTIVE_DESCRIPTOR)
        field(TASK_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cluster?.let { field(CLUSTER_DESCRIPTOR, it) }
        input.command?.let { field(COMMAND_DESCRIPTOR, it) }
        input.container?.let { field(CONTAINER_DESCRIPTOR, it) }
        input.interactive?.let { field(INTERACTIVE_DESCRIPTOR, it) }
        input.task?.let { field(TASK_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
