// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.EcsException
import aws.sdk.kotlin.services.ecs.model.ExecuteCommandResponse
import aws.sdk.kotlin.services.ecs.model.Session
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ExecuteCommandOperationDeserializer: HttpDeserialize<ExecuteCommandResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ExecuteCommandResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExecuteCommandError(context, call)
        }
        val builder = ExecuteCommandResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteCommandOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwExecuteCommandError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ClusterNotFoundException" -> ClusterNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TargetNotConnectedException" -> TargetNotConnectedExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExecuteCommandOperationBody(builder: ExecuteCommandResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterArn"))
    val CONTAINERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("containerArn"))
    val CONTAINERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("containerName"))
    val INTERACTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("interactive"))
    val SESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("session"))
    val TASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERARN_DESCRIPTOR)
        field(CONTAINERARN_DESCRIPTOR)
        field(CONTAINERNAME_DESCRIPTOR)
        field(INTERACTIVE_DESCRIPTOR)
        field(SESSION_DESCRIPTOR)
        field(TASKARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                CONTAINERARN_DESCRIPTOR.index -> builder.containerArn = deserializeString()
                CONTAINERNAME_DESCRIPTOR.index -> builder.containerName = deserializeString()
                INTERACTIVE_DESCRIPTOR.index -> builder.interactive = deserializeBoolean()
                SESSION_DESCRIPTOR.index -> builder.session = deserializeSessionDocument(deserializer)
                TASKARN_DESCRIPTOR.index -> builder.taskArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
