// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.Cluster
import aws.sdk.kotlin.services.ecs.model.DescribeClustersResponse
import aws.sdk.kotlin.services.ecs.model.EcsException
import aws.sdk.kotlin.services.ecs.model.Failure
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeClustersOperationDeserializer: HttpDeserialize<DescribeClustersResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeClustersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeClustersError(context, call)
        }
        val builder = DescribeClustersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeClustersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeClustersError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeClustersOperationBody(builder: DescribeClustersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("clusters"))
    val FAILURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failures"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERS_DESCRIPTOR)
        field(FAILURES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERS_DESCRIPTOR.index -> builder.clusters =
                    deserializer.deserializeList(CLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Cluster>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeClusterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILURES_DESCRIPTOR.index -> builder.failures =
                    deserializer.deserializeList(FAILURES_DESCRIPTOR) {
                        val col0 = mutableListOf<Failure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
