// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a task definition which describes the container and volume definitions of an Amazon Elastic Container Service task. You can specify which Docker images to use, the required resources, and other configurations related to launching the task definition through an Amazon ECS service or task.
 */
public class TaskDefinition private constructor(builder: Builder) {
    /**
     * The task launch types the task definition validated against during task definition registration. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val compatibilities: List<Compatibility>? = builder.compatibilities
    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task. For more information about container definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val containerDefinitions: List<ContainerDefinition>? = builder.containerDefinitions
    /**
     * The number of `cpu` units used by the task. If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the `memory` parameter.
     *
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * + 256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * + 512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * + 1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     * + 2048 (2 vCPU) - Available `memory` values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * + 4096 (4 vCPU) - Available `memory` values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * + 8192 (8 vCPU) - Available `memory` values: 16 GB and 60 GB in 4 GB incrementsThis option requires Linux platform `1.4.0` or later.
     * + 16384 (16vCPU) - Available `memory` values: 32GB and 120 GB in 8 GB incrementsThis option requires Linux platform `1.4.0` or later.
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The Unix timestamp for the time when the task definition was deregistered.
     */
    public val deregisteredAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deregisteredAt
    /**
     * The ephemeral storage settings to use for tasks run with the task definition.
     */
    public val ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = builder.ephemeralStorage
    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The name of a family that this task definition is registered to. Up to 255 characters are allowed. Letters (both uppercase and lowercase letters), numbers, hyphens (-), and underscores (_) are allowed.
     *
     * A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
     */
    public val family: kotlin.String? = builder.family
    /**
     * The Elastic Inference accelerator that's associated with the task.
     */
    public val inferenceAccelerators: List<InferenceAccelerator>? = builder.inferenceAccelerators
    /**
     * The IPC resource namespace to use for the containers in the task. The valid values are `host`, `task`, or `none`. If `host` is specified, then all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If `task` is specified, all containers within the specified task share the same IPC resources. If `none` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the *Docker run reference*.
     *
     * If the `host` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
     *
     * If you are setting namespaced kernel parameters using `systemControls` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
     * + For tasks that use the `host` IPC mode, IPC namespace related `systemControls` are not supported.
     * + For tasks that use the `task` IPC mode, IPC namespace related `systemControls` will apply to all containers within a task.
     *
     * This parameter is not supported for Windows containers or tasks run on Fargate.
     */
    public val ipcMode: aws.sdk.kotlin.services.ecs.model.IpcMode? = builder.ipcMode
    /**
     * The amount (in MiB) of memory used by the task.
     *
     * If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see [ContainerDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
     *
     * If your tasks runs on Fargate, this field is required. You must use one of the following values. The value you choose determines your range of valid values for the `cpu` parameter.
     * + 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256 (.25 vCPU)
     * + 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu` values: 512 (.5 vCPU)
     * + 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
     * + Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available `cpu` values: 2048 (2 vCPU)
     * + Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available `cpu` values: 4096 (4 vCPU)
     * + Between 16 GB and 60 GB in 4 GB increments - Available `cpu` values: 8192 (8 vCPU)This option requires Linux platform `1.4.0` or later.
     * + Between 32GB and 120 GB in 8 GB increments - Available `cpu` values: 16384 (16 vCPU)This option requires Linux platform `1.4.0` or later.
     */
    public val memory: kotlin.String? = builder.memory
    /**
     * The Docker networking mode to use for the containers in the task. The valid values are `none`, `bridge`, `awsvpc`, and `host`. If no network mode is specified, the default is `bridge`.
     *
     * For Amazon ECS tasks on Fargate, the `awsvpc` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, `<default>` or `awsvpc` can be used. If the network mode is set to `none`, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The `host` and `awsvpc` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the `bridge` mode.
     *
     * With the `host` and `awsvpc` network modes, exposed container ports are mapped directly to the corresponding host port (for the `host` network mode) or the attached elastic network interface port (for the `awsvpc` network mode), so you cannot take advantage of dynamic host port mappings.
     *
     * When using the `host` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
     *
     * If the network mode is `awsvpc`, the task is allocated an elastic network interface, and you must specify a NetworkConfiguration value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If the network mode is `host`, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
     *
     * For more information, see [Network settings](https://docs.docker.com/engine/reference/run/#network-settings) in the *Docker run reference*.
     */
    public val networkMode: aws.sdk.kotlin.services.ecs.model.NetworkMode? = builder.networkMode
    /**
     * The process namespace to use for the containers in the task. The valid values are `host` or `task`. On Fargate for Linux containers, the only valid value is `task`. For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
     *
     * If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
     *
     * If `task` is specified, all containers within the specified task share the same process namespace.
     *
     * If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the *Docker run reference*.
     *
     * If the `host` PID mode is used, there's a heightened risk of undesired process namespace exposure. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
     *
     * This parameter is not supported for Windows containers.
     *
     * This parameter is only supported for tasks that are hosted on Fargate if the tasks are using platform version `1.4.0` or later (Linux). This isn't supported for Windows containers on Fargate.
     */
    public val pidMode: aws.sdk.kotlin.services.ecs.model.PidMode? = builder.pidMode
    /**
     * An array of placement constraint objects to use for tasks.
     *
     * This parameter isn't supported for tasks run on Fargate.
     */
    public val placementConstraints: List<TaskDefinitionPlacementConstraint>? = builder.placementConstraints
    /**
     * The configuration details for the App Mesh proxy.
     *
     * Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the `ecs-init` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version `20190301` or later, they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val proxyConfiguration: aws.sdk.kotlin.services.ecs.model.ProxyConfiguration? = builder.proxyConfiguration
    /**
     * The Unix timestamp for the time when the task definition was registered.
     */
    public val registeredAt: aws.smithy.kotlin.runtime.time.Instant? = builder.registeredAt
    /**
     * The principal that registered the task definition.
     */
    public val registeredBy: kotlin.String? = builder.registeredBy
    /**
     * The container instance attributes required by your task. When an Amazon EC2 instance is registered to your cluster, the Amazon ECS container agent assigns some standard attributes to the instance. You can apply custom attributes. These are specified as key-value pairs using the Amazon ECS console or the PutAttributes API. These attributes are used when determining task placement for tasks hosted on Amazon EC2 instances. For more information, see [Attributes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * This parameter isn't supported for tasks run on Fargate.
     */
    public val requiresAttributes: List<Attribute>? = builder.requiresAttributes
    /**
     * The task launch types the task definition was validated against. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val requiresCompatibilities: List<Compatibility>? = builder.requiresCompatibilities
    /**
     * The revision of the task in a particular family. The revision is a version number of a task definition in a family. When you register a task definition for the first time, the revision is `1`. Each time that you register a new revision of a task definition in the same family, the revision value always increases by one. This is even if you deregistered previous revisions in this family.
     */
    public val revision: kotlin.Int = builder.revision
    /**
     * The operating system that your task definitions are running on. A platform family is specified only for tasks using the Fargate launch type.
     *
     * When you specify a task in a service, this value must match the `runtimePlatform` value of the service.
     */
    public val runtimePlatform: aws.sdk.kotlin.services.ecs.model.RuntimePlatform? = builder.runtimePlatform
    /**
     * The status of the task definition.
     */
    public val status: aws.sdk.kotlin.services.ecs.model.TaskDefinitionStatus? = builder.status
    /**
     * The full Amazon Resource Name (ARN) of the task definition.
     */
    public val taskDefinitionArn: kotlin.String? = builder.taskDefinitionArn
    /**
     * The short name or full Amazon Resource Name (ARN) of the Identity and Access Management role that grants containers in the task permission to call Amazon Web Services APIs on your behalf. For more information, see [Amazon ECS Task Role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * IAM roles for tasks on Windows require that the `-EnableTaskIAMRole` option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see [Windows IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val taskRoleArn: kotlin.String? = builder.taskRoleArn
    /**
     * The list of data volume definitions for the task. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * The `host` and `sourcePath` parameters aren't supported for tasks run on Fargate.
     */
    public val volumes: List<Volume>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.TaskDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskDefinition(")
        append("compatibilities=$compatibilities,")
        append("containerDefinitions=$containerDefinitions,")
        append("cpu=$cpu,")
        append("deregisteredAt=$deregisteredAt,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("executionRoleArn=$executionRoleArn,")
        append("family=$family,")
        append("inferenceAccelerators=$inferenceAccelerators,")
        append("ipcMode=$ipcMode,")
        append("memory=$memory,")
        append("networkMode=$networkMode,")
        append("pidMode=$pidMode,")
        append("placementConstraints=$placementConstraints,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("registeredAt=$registeredAt,")
        append("registeredBy=$registeredBy,")
        append("requiresAttributes=$requiresAttributes,")
        append("requiresCompatibilities=$requiresCompatibilities,")
        append("revision=$revision,")
        append("runtimePlatform=$runtimePlatform,")
        append("status=$status,")
        append("taskDefinitionArn=$taskDefinitionArn,")
        append("taskRoleArn=$taskRoleArn,")
        append("volumes=$volumes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compatibilities?.hashCode() ?: 0
        result = 31 * result + (containerDefinitions?.hashCode() ?: 0)
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (deregisteredAt?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (family?.hashCode() ?: 0)
        result = 31 * result + (inferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (ipcMode?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (networkMode?.hashCode() ?: 0)
        result = 31 * result + (pidMode?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (registeredAt?.hashCode() ?: 0)
        result = 31 * result + (registeredBy?.hashCode() ?: 0)
        result = 31 * result + (requiresAttributes?.hashCode() ?: 0)
        result = 31 * result + (requiresCompatibilities?.hashCode() ?: 0)
        result = 31 * result + (revision)
        result = 31 * result + (runtimePlatform?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (taskRoleArn?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskDefinition

        if (compatibilities != other.compatibilities) return false
        if (containerDefinitions != other.containerDefinitions) return false
        if (cpu != other.cpu) return false
        if (deregisteredAt != other.deregisteredAt) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (family != other.family) return false
        if (inferenceAccelerators != other.inferenceAccelerators) return false
        if (ipcMode != other.ipcMode) return false
        if (memory != other.memory) return false
        if (networkMode != other.networkMode) return false
        if (pidMode != other.pidMode) return false
        if (placementConstraints != other.placementConstraints) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (registeredAt != other.registeredAt) return false
        if (registeredBy != other.registeredBy) return false
        if (requiresAttributes != other.requiresAttributes) return false
        if (requiresCompatibilities != other.requiresCompatibilities) return false
        if (revision != other.revision) return false
        if (runtimePlatform != other.runtimePlatform) return false
        if (status != other.status) return false
        if (taskDefinitionArn != other.taskDefinitionArn) return false
        if (taskRoleArn != other.taskRoleArn) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.TaskDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The task launch types the task definition validated against during task definition registration. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var compatibilities: List<Compatibility>? = null
        /**
         * A list of container definitions in JSON format that describe the different containers that make up your task. For more information about container definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var containerDefinitions: List<ContainerDefinition>? = null
        /**
         * The number of `cpu` units used by the task. If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the `memory` parameter.
         *
         * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         * + 256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * + 512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * + 1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * + 2048 (2 vCPU) - Available `memory` values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         * + 4096 (4 vCPU) - Available `memory` values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * + 8192 (8 vCPU) - Available `memory` values: 16 GB and 60 GB in 4 GB incrementsThis option requires Linux platform `1.4.0` or later.
         * + 16384 (16vCPU) - Available `memory` values: 32GB and 120 GB in 8 GB incrementsThis option requires Linux platform `1.4.0` or later.
         */
        public var cpu: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the task definition was deregistered.
         */
        public var deregisteredAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ephemeral storage settings to use for tasks run with the task definition.
         */
        public var ephemeralStorage: aws.sdk.kotlin.services.ecs.model.EphemeralStorage? = null
        /**
         * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see [Amazon ECS task execution IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The name of a family that this task definition is registered to. Up to 255 characters are allowed. Letters (both uppercase and lowercase letters), numbers, hyphens (-), and underscores (_) are allowed.
         *
         * A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
         */
        public var family: kotlin.String? = null
        /**
         * The Elastic Inference accelerator that's associated with the task.
         */
        public var inferenceAccelerators: List<InferenceAccelerator>? = null
        /**
         * The IPC resource namespace to use for the containers in the task. The valid values are `host`, `task`, or `none`. If `host` is specified, then all containers within the tasks that specified the `host` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If `task` is specified, all containers within the specified task share the same IPC resources. If `none` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see [IPC settings](https://docs.docker.com/engine/reference/run/#ipc-settings---ipc) in the *Docker run reference*.
         *
         * If the `host` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
         *
         * If you are setting namespaced kernel parameters using `systemControls` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
         * + For tasks that use the `host` IPC mode, IPC namespace related `systemControls` are not supported.
         * + For tasks that use the `task` IPC mode, IPC namespace related `systemControls` will apply to all containers within a task.
         *
         * This parameter is not supported for Windows containers or tasks run on Fargate.
         */
        public var ipcMode: aws.sdk.kotlin.services.ecs.model.IpcMode? = null
        /**
         * The amount (in MiB) of memory used by the task.
         *
         * If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see [ContainerDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
         *
         * If your tasks runs on Fargate, this field is required. You must use one of the following values. The value you choose determines your range of valid values for the `cpu` parameter.
         * + 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256 (.25 vCPU)
         * + 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu` values: 512 (.5 vCPU)
         * + 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
         * + Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available `cpu` values: 2048 (2 vCPU)
         * + Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available `cpu` values: 4096 (4 vCPU)
         * + Between 16 GB and 60 GB in 4 GB increments - Available `cpu` values: 8192 (8 vCPU)This option requires Linux platform `1.4.0` or later.
         * + Between 32GB and 120 GB in 8 GB increments - Available `cpu` values: 16384 (16 vCPU)This option requires Linux platform `1.4.0` or later.
         */
        public var memory: kotlin.String? = null
        /**
         * The Docker networking mode to use for the containers in the task. The valid values are `none`, `bridge`, `awsvpc`, and `host`. If no network mode is specified, the default is `bridge`.
         *
         * For Amazon ECS tasks on Fargate, the `awsvpc` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, `<default>` or `awsvpc` can be used. If the network mode is set to `none`, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The `host` and `awsvpc` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the `bridge` mode.
         *
         * With the `host` and `awsvpc` network modes, exposed container ports are mapped directly to the corresponding host port (for the `host` network mode) or the attached elastic network interface port (for the `awsvpc` network mode), so you cannot take advantage of dynamic host port mappings.
         *
         * When using the `host` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
         *
         * If the network mode is `awsvpc`, the task is allocated an elastic network interface, and you must specify a NetworkConfiguration value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If the network mode is `host`, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
         *
         * For more information, see [Network settings](https://docs.docker.com/engine/reference/run/#network-settings) in the *Docker run reference*.
         */
        public var networkMode: aws.sdk.kotlin.services.ecs.model.NetworkMode? = null
        /**
         * The process namespace to use for the containers in the task. The valid values are `host` or `task`. On Fargate for Linux containers, the only valid value is `task`. For example, monitoring sidecars might need `pidMode` to access information about other containers running in the same task.
         *
         * If `host` is specified, all containers within the tasks that specified the `host` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
         *
         * If `task` is specified, all containers within the specified task share the same process namespace.
         *
         * If no value is specified, the default is a private namespace for each container. For more information, see [PID settings](https://docs.docker.com/engine/reference/run/#pid-settings---pid) in the *Docker run reference*.
         *
         * If the `host` PID mode is used, there's a heightened risk of undesired process namespace exposure. For more information, see [Docker security](https://docs.docker.com/engine/security/security/).
         *
         * This parameter is not supported for Windows containers.
         *
         * This parameter is only supported for tasks that are hosted on Fargate if the tasks are using platform version `1.4.0` or later (Linux). This isn't supported for Windows containers on Fargate.
         */
        public var pidMode: aws.sdk.kotlin.services.ecs.model.PidMode? = null
        /**
         * An array of placement constraint objects to use for tasks.
         *
         * This parameter isn't supported for tasks run on Fargate.
         */
        public var placementConstraints: List<TaskDefinitionPlacementConstraint>? = null
        /**
         * The configuration details for the App Mesh proxy.
         *
         * Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the `ecs-init` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version `20190301` or later, they contain the required versions of the container agent and `ecs-init`. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var proxyConfiguration: aws.sdk.kotlin.services.ecs.model.ProxyConfiguration? = null
        /**
         * The Unix timestamp for the time when the task definition was registered.
         */
        public var registeredAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The principal that registered the task definition.
         */
        public var registeredBy: kotlin.String? = null
        /**
         * The container instance attributes required by your task. When an Amazon EC2 instance is registered to your cluster, the Amazon ECS container agent assigns some standard attributes to the instance. You can apply custom attributes. These are specified as key-value pairs using the Amazon ECS console or the PutAttributes API. These attributes are used when determining task placement for tasks hosted on Amazon EC2 instances. For more information, see [Attributes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * This parameter isn't supported for tasks run on Fargate.
         */
        public var requiresAttributes: List<Attribute>? = null
        /**
         * The task launch types the task definition was validated against. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var requiresCompatibilities: List<Compatibility>? = null
        /**
         * The revision of the task in a particular family. The revision is a version number of a task definition in a family. When you register a task definition for the first time, the revision is `1`. Each time that you register a new revision of a task definition in the same family, the revision value always increases by one. This is even if you deregistered previous revisions in this family.
         */
        public var revision: kotlin.Int = 0
        /**
         * The operating system that your task definitions are running on. A platform family is specified only for tasks using the Fargate launch type.
         *
         * When you specify a task in a service, this value must match the `runtimePlatform` value of the service.
         */
        public var runtimePlatform: aws.sdk.kotlin.services.ecs.model.RuntimePlatform? = null
        /**
         * The status of the task definition.
         */
        public var status: aws.sdk.kotlin.services.ecs.model.TaskDefinitionStatus? = null
        /**
         * The full Amazon Resource Name (ARN) of the task definition.
         */
        public var taskDefinitionArn: kotlin.String? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the Identity and Access Management role that grants containers in the task permission to call Amazon Web Services APIs on your behalf. For more information, see [Amazon ECS Task Role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * IAM roles for tasks on Windows require that the `-EnableTaskIAMRole` option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see [Windows IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var taskRoleArn: kotlin.String? = null
        /**
         * The list of data volume definitions for the task. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * The `host` and `sourcePath` parameters aren't supported for tasks run on Fargate.
         */
        public var volumes: List<Volume>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.TaskDefinition) : this() {
            this.compatibilities = x.compatibilities
            this.containerDefinitions = x.containerDefinitions
            this.cpu = x.cpu
            this.deregisteredAt = x.deregisteredAt
            this.ephemeralStorage = x.ephemeralStorage
            this.executionRoleArn = x.executionRoleArn
            this.family = x.family
            this.inferenceAccelerators = x.inferenceAccelerators
            this.ipcMode = x.ipcMode
            this.memory = x.memory
            this.networkMode = x.networkMode
            this.pidMode = x.pidMode
            this.placementConstraints = x.placementConstraints
            this.proxyConfiguration = x.proxyConfiguration
            this.registeredAt = x.registeredAt
            this.registeredBy = x.registeredBy
            this.requiresAttributes = x.requiresAttributes
            this.requiresCompatibilities = x.requiresCompatibilities
            this.revision = x.revision
            this.runtimePlatform = x.runtimePlatform
            this.status = x.status
            this.taskDefinitionArn = x.taskDefinitionArn
            this.taskRoleArn = x.taskRoleArn
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.TaskDefinition = TaskDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.EphemeralStorage] inside the given [block]
         */
        public fun ephemeralStorage(block: aws.sdk.kotlin.services.ecs.model.EphemeralStorage.Builder.() -> kotlin.Unit) {
            this.ephemeralStorage = aws.sdk.kotlin.services.ecs.model.EphemeralStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ProxyConfiguration] inside the given [block]
         */
        public fun proxyConfiguration(block: aws.sdk.kotlin.services.ecs.model.ProxyConfiguration.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.ecs.model.ProxyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.RuntimePlatform] inside the given [block]
         */
        public fun runtimePlatform(block: aws.sdk.kotlin.services.ecs.model.RuntimePlatform.Builder.() -> kotlin.Unit) {
            this.runtimePlatform = aws.sdk.kotlin.services.ecs.model.RuntimePlatform.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
