// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The details for the service registry.
 *
 * Each service may be associated with one service registry. Multiple service registries for each service are not supported.
 *
 * When you add, update, or remove the service registries configuration, Amazon ECS starts a new deployment. New tasks are registered and deregistered to the updated service registry configuration.
 */
public class ServiceRegistry private constructor(builder: Builder) {
    /**
     * The container name value to be used for your service discovery service. It's already specified in the task definition. If the task definition that your service task specifies uses the `bridge` or `host` network mode, you must specify a `containerName` and `containerPort` combination from the task definition. If the task definition that your service task specifies uses the `awsvpc` network mode and a type SRV DNS record is used, you must specify either a `containerName` and `containerPort` combination or a `port` value. However, you can't specify both.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * The port value to be used for your service discovery service. It's already specified in the task definition. If the task definition your service task specifies uses the `bridge` or `host` network mode, you must specify a `containerName` and `containerPort` combination from the task definition. If the task definition your service task specifies uses the `awsvpc` network mode and a type SRV DNS record is used, you must specify either a `containerName` and `containerPort` combination or a `port` value. However, you can't specify both.
     */
    public val containerPort: kotlin.Int? = builder.containerPort
    /**
     * The port value used if your service discovery service specified an SRV record. This field might be used if both the `awsvpc` network mode and SRV records are used.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is Cloud Map. For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
     */
    public val registryArn: kotlin.String? = builder.registryArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ServiceRegistry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceRegistry(")
        append("containerName=$containerName,")
        append("containerPort=$containerPort,")
        append("port=$port,")
        append("registryArn=$registryArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (containerPort ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (registryArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceRegistry

        if (containerName != other.containerName) return false
        if (containerPort != other.containerPort) return false
        if (port != other.port) return false
        if (registryArn != other.registryArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ServiceRegistry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The container name value to be used for your service discovery service. It's already specified in the task definition. If the task definition that your service task specifies uses the `bridge` or `host` network mode, you must specify a `containerName` and `containerPort` combination from the task definition. If the task definition that your service task specifies uses the `awsvpc` network mode and a type SRV DNS record is used, you must specify either a `containerName` and `containerPort` combination or a `port` value. However, you can't specify both.
         */
        public var containerName: kotlin.String? = null
        /**
         * The port value to be used for your service discovery service. It's already specified in the task definition. If the task definition your service task specifies uses the `bridge` or `host` network mode, you must specify a `containerName` and `containerPort` combination from the task definition. If the task definition your service task specifies uses the `awsvpc` network mode and a type SRV DNS record is used, you must specify either a `containerName` and `containerPort` combination or a `port` value. However, you can't specify both.
         */
        public var containerPort: kotlin.Int? = null
        /**
         * The port value used if your service discovery service specified an SRV record. This field might be used if both the `awsvpc` network mode and SRV records are used.
         */
        public var port: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is Cloud Map. For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
         */
        public var registryArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ServiceRegistry) : this() {
            this.containerName = x.containerName
            this.containerPort = x.containerPort
            this.port = x.port
            this.registryArn = x.registryArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ServiceRegistry = ServiceRegistry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
