// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class PutClusterCapacityProvidersRequest private constructor(builder: Builder) {
    /**
     * The name of one or more capacity providers to associate with the cluster.
     *
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     *
     * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     */
    public val capacityProviders: List<String>? = builder.capacityProviders
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings for. If you don't specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The capacity provider strategy to use by default for the cluster.
     *
     * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified then the default capacity provider strategy for the cluster is used.
     *
     * A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
     *
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     *
     * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     */
    public val defaultCapacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.defaultCapacityProviderStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.PutClusterCapacityProvidersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutClusterCapacityProvidersRequest(")
        append("capacityProviders=$capacityProviders,")
        append("cluster=$cluster,")
        append("defaultCapacityProviderStrategy=$defaultCapacityProviderStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviders?.hashCode() ?: 0
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (defaultCapacityProviderStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutClusterCapacityProvidersRequest

        if (capacityProviders != other.capacityProviders) return false
        if (cluster != other.cluster) return false
        if (defaultCapacityProviderStrategy != other.defaultCapacityProviderStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.PutClusterCapacityProvidersRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of one or more capacity providers to associate with the cluster.
         *
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
         *
         * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         */
        public var capacityProviders: List<String>? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings for. If you don't specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * The capacity provider strategy to use by default for the cluster.
         *
         * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified then the default capacity provider strategy for the cluster is used.
         *
         * A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
         *
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
         *
         * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         */
        public var defaultCapacityProviderStrategy: List<CapacityProviderStrategyItem>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.PutClusterCapacityProvidersRequest) : this() {
            this.capacityProviders = x.capacityProviders
            this.cluster = x.cluster
            this.defaultCapacityProviderStrategy = x.defaultCapacityProviderStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.PutClusterCapacityProvidersRequest = PutClusterCapacityProvidersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
