// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class PutAccountSettingDefaultRequest private constructor(builder: Builder) {
    /**
     * The resource name for which to modify the account setting. If you specify `serviceLongArnFormat`, the ARN for your Amazon ECS services is affected. If you specify `taskLongArnFormat`, the ARN and resource ID for your Amazon ECS tasks is affected. If you specify `containerInstanceLongArnFormat`, the ARN and resource ID for your Amazon ECS container instances is affected. If you specify `awsvpcTrunking`, the ENI limit for your Amazon ECS container instances is affected. If you specify `containerInsights`, the default setting for Amazon Web Services CloudWatch Container Insights for your clusters is affected. If you specify `tagResourceAuthorization`, the opt-in option for tagging resources on creation is affected. For information about the opt-in timeline, see [Tagging authorization timeline](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#tag-resources) in the *Amazon ECS Developer Guide*. If you specify `fargateTaskRetirementWaitPeriod`, the default wait time to retire a Fargate task due to required maintenance is affected.
     *
     * When you specify `fargateFIPSMode` for the `name` and `enabled` for the `value`, Fargate uses FIPS-140 compliant cryptographic algorithms on your tasks. For more information about FIPS-140 compliance with Fargate, see [ Amazon Web Services Fargate Federal Information Processing Standard (FIPS) 140-2 compliance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-fips-compliance.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * When Amazon Web Services determines that a security or infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and new tasks launched to replace them. Use `fargateTaskRetirementWaitPeriod` to set the wait time to retire a Fargate task to the default. For information about the Fargate tasks maintenance, see [Amazon Web Services Fargate task maintenance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html) in the *Amazon ECS Developer Guide*.
     *
     * The `guardDutyActivate` parameter is read-only in Amazon ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see [Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html).
     */
    public val name: aws.sdk.kotlin.services.ecs.model.SettingName? = builder.name
    /**
     * The account setting value for the specified principal ARN. Accepted values are `enabled`, `disabled`, `on`, and `off`.
     *
     * When you specify `fargateTaskRetirementWaitPeriod` for the `name`, the following are the valid values:
     * + `0` - Amazon Web Services sends the notification, and immediately retires the affected tasks.
     * + `7` - Amazon Web Services sends the notification, and waits 7 calendar days to retire the tasks.
     * + `14` - Amazon Web Services sends the notification, and waits 14 calendar days to retire the tasks.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.PutAccountSettingDefaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAccountSettingDefaultRequest(")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAccountSettingDefaultRequest

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.PutAccountSettingDefaultRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The resource name for which to modify the account setting. If you specify `serviceLongArnFormat`, the ARN for your Amazon ECS services is affected. If you specify `taskLongArnFormat`, the ARN and resource ID for your Amazon ECS tasks is affected. If you specify `containerInstanceLongArnFormat`, the ARN and resource ID for your Amazon ECS container instances is affected. If you specify `awsvpcTrunking`, the ENI limit for your Amazon ECS container instances is affected. If you specify `containerInsights`, the default setting for Amazon Web Services CloudWatch Container Insights for your clusters is affected. If you specify `tagResourceAuthorization`, the opt-in option for tagging resources on creation is affected. For information about the opt-in timeline, see [Tagging authorization timeline](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#tag-resources) in the *Amazon ECS Developer Guide*. If you specify `fargateTaskRetirementWaitPeriod`, the default wait time to retire a Fargate task due to required maintenance is affected.
         *
         * When you specify `fargateFIPSMode` for the `name` and `enabled` for the `value`, Fargate uses FIPS-140 compliant cryptographic algorithms on your tasks. For more information about FIPS-140 compliance with Fargate, see [ Amazon Web Services Fargate Federal Information Processing Standard (FIPS) 140-2 compliance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-fips-compliance.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * When Amazon Web Services determines that a security or infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and new tasks launched to replace them. Use `fargateTaskRetirementWaitPeriod` to set the wait time to retire a Fargate task to the default. For information about the Fargate tasks maintenance, see [Amazon Web Services Fargate task maintenance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html) in the *Amazon ECS Developer Guide*.
         *
         * The `guardDutyActivate` parameter is read-only in Amazon ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see [Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html).
         */
        public var name: aws.sdk.kotlin.services.ecs.model.SettingName? = null
        /**
         * The account setting value for the specified principal ARN. Accepted values are `enabled`, `disabled`, `on`, and `off`.
         *
         * When you specify `fargateTaskRetirementWaitPeriod` for the `name`, the following are the valid values:
         * + `0` - Amazon Web Services sends the notification, and immediately retires the affected tasks.
         * + `7` - Amazon Web Services sends the notification, and waits 7 calendar days to retire the tasks.
         * + `14` - Amazon Web Services sends the notification, and waits 14 calendar days to retire the tasks.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.PutAccountSettingDefaultRequest) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.PutAccountSettingDefaultRequest = PutAccountSettingDefaultRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
