// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing the protection status details for a task. You can set the protection status with the UpdateTaskProtection API and get the status of tasks with the GetTaskProtection API.
 */
public class ProtectedTask private constructor(builder: Builder) {
    /**
     * The epoch time when protection for the task will expire.
     */
    public val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The protection status of the task. If scale-in protection is on for a task, the value is `true`. Otherwise, it is `false`.
     */
    public val protectionEnabled: kotlin.Boolean = builder.protectionEnabled
    /**
     * The task ARN.
     */
    public val taskArn: kotlin.String? = builder.taskArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ProtectedTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtectedTask(")
        append("expirationDate=$expirationDate,")
        append("protectionEnabled=$protectionEnabled,")
        append("taskArn=$taskArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expirationDate?.hashCode() ?: 0
        result = 31 * result + (protectionEnabled.hashCode())
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtectedTask

        if (expirationDate != other.expirationDate) return false
        if (protectionEnabled != other.protectionEnabled) return false
        if (taskArn != other.taskArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ProtectedTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The epoch time when protection for the task will expire.
         */
        public var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The protection status of the task. If scale-in protection is on for a task, the value is `true`. Otherwise, it is `false`.
         */
        public var protectionEnabled: kotlin.Boolean = false
        /**
         * The task ARN.
         */
        public var taskArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ProtectedTask) : this() {
            this.expirationDate = x.expirationDate
            this.protectionEnabled = x.protectionEnabled
            this.taskArn = x.taskArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ProtectedTask = ProtectedTask(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
