// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * An object representing a change in state for a managed agent.
 */
public class ManagedAgentStateChange private constructor(builder: Builder) {
    /**
     * The name of the container that's associated with the managed agent.
     */
    public val containerName: kotlin.String = requireNotNull(builder.containerName) { "A non-null value must be provided for containerName" }
    /**
     * The name of the managed agent.
     */
    public val managedAgentName: aws.sdk.kotlin.services.ecs.model.ManagedAgentName = requireNotNull(builder.managedAgentName) { "A non-null value must be provided for managedAgentName" }
    /**
     * The reason for the status of the managed agent.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The status of the managed agent.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ManagedAgentStateChange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManagedAgentStateChange(")
        append("containerName=$containerName,")
        append("managedAgentName=$managedAgentName,")
        append("reason=$reason,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName.hashCode()
        result = 31 * result + (managedAgentName.hashCode())
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManagedAgentStateChange

        if (containerName != other.containerName) return false
        if (managedAgentName != other.managedAgentName) return false
        if (reason != other.reason) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ManagedAgentStateChange = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the container that's associated with the managed agent.
         */
        public var containerName: kotlin.String? = null
        /**
         * The name of the managed agent.
         */
        public var managedAgentName: aws.sdk.kotlin.services.ecs.model.ManagedAgentName? = null
        /**
         * The reason for the status of the managed agent.
         */
        public var reason: kotlin.String? = null
        /**
         * The status of the managed agent.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ManagedAgentStateChange) : this() {
            this.containerName = x.containerName
            this.managedAgentName = x.managedAgentName
            this.reason = x.reason
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ManagedAgentStateChange = ManagedAgentStateChange(this)

        internal fun correctErrors(): Builder {
            if (containerName == null) containerName = ""
            if (managedAgentName == null) managedAgentName = ManagedAgentName.SdkUnknown("no value provided")
            if (status == null) status = ""
            return this
        }
    }
}
