// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The load balancer configuration to use with a service or task set.
 *
 * When you add, update, or remove a load balancer configuration, Amazon ECS starts a new deployment with the updated Elastic Load Balancing configuration. This causes tasks to register to and deregister from load balancers.
 *
 * We recommend that you verify this on a test environment before you update the Elastic Load Balancing configuration.
 *
 * A service-linked role is required for services that use multiple target groups. For more information, see [Using service-linked roles](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class LoadBalancer private constructor(builder: Builder) {
    /**
     * The name of the container (as it appears in a container definition) to associate with the load balancer.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * The port on the container to associate with the load balancer. This port must correspond to a `containerPort` in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the `hostPort` of the port mapping.
     */
    public val containerPort: kotlin.Int? = builder.containerPort
    /**
     * The name of the load balancer to associate with the Amazon ECS service or task set.
     *
     * If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
     *
     * A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer.
     *
     * For services using the `ECS` deployment controller, you can specify one or multiple target groups. For more information, see [Registering multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For services using the `CODE_DEPLOY` deployment controller, you're required to define two target groups for the load balancer. For more information, see [Blue/green deployment with CodeDeploy](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If your service's task definition uses the `awsvpc` network mode, you must choose `ip` as the target type, not `instance`. Do this when creating your target groups because tasks that use the `awsvpc` network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
     */
    public val targetGroupArn: kotlin.String? = builder.targetGroupArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.LoadBalancer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancer(")
        append("containerName=$containerName,")
        append("containerPort=$containerPort,")
        append("loadBalancerName=$loadBalancerName,")
        append("targetGroupArn=$targetGroupArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (containerPort ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancer

        if (containerName != other.containerName) return false
        if (containerPort != other.containerPort) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (targetGroupArn != other.targetGroupArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.LoadBalancer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the container (as it appears in a container definition) to associate with the load balancer.
         */
        public var containerName: kotlin.String? = null
        /**
         * The port on the container to associate with the load balancer. This port must correspond to a `containerPort` in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the `hostPort` of the port mapping.
         */
        public var containerPort: kotlin.Int? = null
        /**
         * The name of the load balancer to associate with the Amazon ECS service or task set.
         *
         * If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
         *
         * A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer.
         *
         * For services using the `ECS` deployment controller, you can specify one or multiple target groups. For more information, see [Registering multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * For services using the `CODE_DEPLOY` deployment controller, you're required to define two target groups for the load balancer. For more information, see [Blue/green deployment with CodeDeploy](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If your service's task definition uses the `awsvpc` network mode, you must choose `ip` as the target type, not `instance`. Do this when creating your target groups because tasks that use the `awsvpc` network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
         */
        public var targetGroupArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.LoadBalancer) : this() {
            this.containerName = x.containerName
            this.containerPort = x.containerPort
            this.loadBalancerName = x.loadBalancerName
            this.targetGroupArn = x.targetGroupArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.LoadBalancer = LoadBalancer(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
