// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The authorization configuration details for Amazon FSx for Windows File Server file system. See [FSxWindowsFileServerVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html) in the *Amazon ECS API Reference*.
 *
 * For more information and the input format, see [Amazon FSx for Windows File Server Volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class FSxWindowsFileServerAuthorizationConfig private constructor(builder: Builder) {
    /**
     * The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM Parameter Store parameter. The ARN refers to the stored credentials.
     */
    public val credentialsParameter: kotlin.String = requireNotNull(builder.credentialsParameter) { "A non-null value must be provided for credentialsParameter" }
    /**
     * A fully qualified domain name hosted by an [Directory Service](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html) Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
     */
    public val domain: kotlin.String = requireNotNull(builder.domain) { "A non-null value must be provided for domain" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FSxWindowsFileServerAuthorizationConfig(")
        append("credentialsParameter=$credentialsParameter,")
        append("domain=$domain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentialsParameter.hashCode()
        result = 31 * result + (domain.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FSxWindowsFileServerAuthorizationConfig

        if (credentialsParameter != other.credentialsParameter) return false
        if (domain != other.domain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM Parameter Store parameter. The ARN refers to the stored credentials.
         */
        public var credentialsParameter: kotlin.String? = null
        /**
         * A fully qualified domain name hosted by an [Directory Service](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html) Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
         */
        public var domain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig) : this() {
            this.credentialsParameter = x.credentialsParameter
            this.domain = x.domain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.FSxWindowsFileServerAuthorizationConfig = FSxWindowsFileServerAuthorizationConfig(this)

        internal fun correctErrors(): Builder {
            if (credentialsParameter == null) credentialsParameter = ""
            if (domain == null) domain = ""
            return this
        }
    }
}
