// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The tag specifications of an Amazon EBS volume.
 */
public class EbsTagSpecification private constructor(builder: Builder) {
    /**
     * Determines whether to propagate the tags from the task definition to  the Amazon EBS volume. Tags can only propagate to a `SERVICE` specified in  `ServiceVolumeConfiguration`. If no value is specified, the tags aren't  propagated.
     */
    public val propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = builder.propagateTags
    /**
     * The type of volume resource.
     */
    public val resourceType: aws.sdk.kotlin.services.ecs.model.EbsResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The tags applied to this Amazon EBS volume. `AmazonECSCreated` and `AmazonECSManaged` are reserved tags that can't be used.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.EbsTagSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsTagSpecification(")
        append("propagateTags=$propagateTags,")
        append("resourceType=$resourceType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = propagateTags?.hashCode() ?: 0
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsTagSpecification

        if (propagateTags != other.propagateTags) return false
        if (resourceType != other.resourceType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.EbsTagSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether to propagate the tags from the task definition to  the Amazon EBS volume. Tags can only propagate to a `SERVICE` specified in  `ServiceVolumeConfiguration`. If no value is specified, the tags aren't  propagated.
         */
        public var propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = null
        /**
         * The type of volume resource.
         */
        public var resourceType: aws.sdk.kotlin.services.ecs.model.EbsResourceType? = null
        /**
         * The tags applied to this Amazon EBS volume. `AmazonECSCreated` and `AmazonECSManaged` are reserved tags that can't be used.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.EbsTagSpecification) : this() {
            this.propagateTags = x.propagateTags
            this.resourceType = x.resourceType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.EbsTagSpecification = EbsTagSpecification(this)

        internal fun correctErrors(): Builder {
            if (resourceType == null) resourceType = EbsResourceType.SdkUnknown("no value provided")
            return this
        }
    }
}
