// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * One of the methods which provide a way for you to quickly identify when a deployment has failed, and then to optionally roll back the failure to the last working deployment.
 *
 * When the alarms are generated, Amazon ECS sets the service deployment to failed. Set the rollback parameter to have Amazon ECS to roll back your service to the last completed deployment after a failure.
 *
 * You can only use the `DeploymentAlarms` method to detect failures when the `DeploymentController` is set to `ECS` (rolling update).
 *
 * For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the **Amazon Elastic Container Service Developer Guide**.
 */
public class DeploymentAlarms private constructor(builder: Builder) {
    /**
     * One or more CloudWatch alarm names. Use a "," to separate the alarms.
     */
    public val alarmNames: List<String> = requireNotNull(builder.alarmNames) { "A non-null value must be provided for alarmNames" }
    /**
     * Determines whether to use the CloudWatch alarm option in the service deployment process.
     */
    public val enable: kotlin.Boolean = builder.enable
    /**
     * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
     */
    public val rollback: kotlin.Boolean = builder.rollback

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.DeploymentAlarms = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentAlarms(")
        append("alarmNames=$alarmNames,")
        append("enable=$enable,")
        append("rollback=$rollback")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmNames.hashCode()
        result = 31 * result + (enable.hashCode())
        result = 31 * result + (rollback.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentAlarms

        if (alarmNames != other.alarmNames) return false
        if (enable != other.enable) return false
        if (rollback != other.rollback) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.DeploymentAlarms = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more CloudWatch alarm names. Use a "," to separate the alarms.
         */
        public var alarmNames: List<String>? = null
        /**
         * Determines whether to use the CloudWatch alarm option in the service deployment process.
         */
        public var enable: kotlin.Boolean = false
        /**
         * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
         */
        public var rollback: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.DeploymentAlarms) : this() {
            this.alarmNames = x.alarmNames
            this.enable = x.enable
            this.rollback = x.rollback
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.DeploymentAlarms = DeploymentAlarms(this)

        internal fun correctErrors(): Builder {
            if (alarmNames == null) alarmNames = emptyList()
            return this
        }
    }
}
