// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The overrides that are sent to a container. An empty container override can be passed in. An example of an empty container override is `{"containerOverrides": [ ] }`. If a non-empty container override is specified, the `name` parameter must be included.
 *
 * You can use Secrets Manager or Amazon Web Services Systems Manager Parameter Store to store the sensitive data. For more information, see [Retrieve secrets through environment variables](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/secrets-envvar.html) in the Amazon ECS Developer Guide.
 */
public class ContainerOverride private constructor(builder: Builder) {
    /**
     * The command to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    public val command: List<String>? = builder.command
    /**
     * The number of `cpu` units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    public val cpu: kotlin.Int? = builder.cpu
    /**
     * The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
     */
    public val environment: List<KeyValuePair>? = builder.environment
    /**
     * A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
     */
    public val environmentFiles: List<EnvironmentFile>? = builder.environmentFiles
    /**
     * The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    public val memory: kotlin.Int? = builder.memory
    /**
     * The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    public val memoryReservation: kotlin.Int? = builder.memoryReservation
    /**
     * The name of the container that receives the override. This parameter is required if any override is specified.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU.
     */
    public val resourceRequirements: List<ResourceRequirement>? = builder.resourceRequirements

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ContainerOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerOverride(")
        append("command=$command,")
        append("cpu=$cpu,")
        append("environment=$environment,")
        append("environmentFiles=$environmentFiles,")
        append("memory=$memory,")
        append("memoryReservation=$memoryReservation,")
        append("name=$name,")
        append("resourceRequirements=$resourceRequirements")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (cpu ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (environmentFiles?.hashCode() ?: 0)
        result = 31 * result + (memory ?: 0)
        result = 31 * result + (memoryReservation ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceRequirements?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerOverride

        if (command != other.command) return false
        if (cpu != other.cpu) return false
        if (environment != other.environment) return false
        if (environmentFiles != other.environmentFiles) return false
        if (memory != other.memory) return false
        if (memoryReservation != other.memoryReservation) return false
        if (name != other.name) return false
        if (resourceRequirements != other.resourceRequirements) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ContainerOverride = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The command to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
         */
        public var command: List<String>? = null
        /**
         * The number of `cpu` units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
         */
        public var cpu: kotlin.Int? = null
        /**
         * The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
         */
        public var environment: List<KeyValuePair>? = null
        /**
         * A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
         */
        public var environmentFiles: List<EnvironmentFile>? = null
        /**
         * The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
         */
        public var memory: kotlin.Int? = null
        /**
         * The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
         */
        public var memoryReservation: kotlin.Int? = null
        /**
         * The name of the container that receives the override. This parameter is required if any override is specified.
         */
        public var name: kotlin.String? = null
        /**
         * The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU.
         */
        public var resourceRequirements: List<ResourceRequirement>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ContainerOverride) : this() {
            this.command = x.command
            this.cpu = x.cpu
            this.environment = x.environment
            this.environmentFiles = x.environmentFiles
            this.memory = x.memory
            this.memoryReservation = x.memoryReservation
            this.name = x.name
            this.resourceRequirements = x.resourceRequirements
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ContainerOverride = ContainerOverride(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
