// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The details for a capacity provider.
 */
public class CapacityProvider private constructor(builder: Builder) {
    /**
     * The Auto Scaling group settings for the capacity provider.
     */
    public val autoScalingGroupProvider: aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider? = builder.autoScalingGroupProvider
    /**
     * The Amazon Resource Name (ARN) that identifies the capacity provider.
     */
    public val capacityProviderArn: kotlin.String? = builder.capacityProviderArn
    /**
     * The name of the capacity provider.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current status of the capacity provider. Only capacity providers in an `ACTIVE` state can be used in a cluster. When a capacity provider is successfully deleted, it has an `INACTIVE` status.
     */
    public val status: aws.sdk.kotlin.services.ecs.model.CapacityProviderStatus? = builder.status
    /**
     * The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The update status of the capacity provider. The following are the possible states that is returned.
     *
     * ## DELETE_IN_PROGRESS
     * The capacity provider is in the process of being deleted.
     *
     * ## DELETE_COMPLETE
     * The capacity provider was successfully deleted and has an `INACTIVE` status.
     *
     * ## DELETE_FAILED
     * The capacity provider can't be deleted. The update status reason provides further details about why the delete failed.
     */
    public val updateStatus: aws.sdk.kotlin.services.ecs.model.CapacityProviderUpdateStatus? = builder.updateStatus
    /**
     * The update status reason. This provides further details about the update status for the capacity provider.
     */
    public val updateStatusReason: kotlin.String? = builder.updateStatusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.CapacityProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityProvider(")
        append("autoScalingGroupProvider=$autoScalingGroupProvider,")
        append("capacityProviderArn=$capacityProviderArn,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags,")
        append("updateStatus=$updateStatus,")
        append("updateStatusReason=$updateStatusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingGroupProvider?.hashCode() ?: 0
        result = 31 * result + (capacityProviderArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        result = 31 * result + (updateStatusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityProvider

        if (autoScalingGroupProvider != other.autoScalingGroupProvider) return false
        if (capacityProviderArn != other.capacityProviderArn) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (updateStatus != other.updateStatus) return false
        if (updateStatusReason != other.updateStatusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.CapacityProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Auto Scaling group settings for the capacity provider.
         */
        public var autoScalingGroupProvider: aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the capacity provider.
         */
        public var capacityProviderArn: kotlin.String? = null
        /**
         * The name of the capacity provider.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the capacity provider. Only capacity providers in an `ACTIVE` state can be used in a cluster. When a capacity provider is successfully deleted, it has an `INACTIVE` status.
         */
        public var status: aws.sdk.kotlin.services.ecs.model.CapacityProviderStatus? = null
        /**
         * The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The update status of the capacity provider. The following are the possible states that is returned.
         *
         * ## DELETE_IN_PROGRESS
         * The capacity provider is in the process of being deleted.
         *
         * ## DELETE_COMPLETE
         * The capacity provider was successfully deleted and has an `INACTIVE` status.
         *
         * ## DELETE_FAILED
         * The capacity provider can't be deleted. The update status reason provides further details about why the delete failed.
         */
        public var updateStatus: aws.sdk.kotlin.services.ecs.model.CapacityProviderUpdateStatus? = null
        /**
         * The update status reason. This provides further details about the update status for the capacity provider.
         */
        public var updateStatusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.CapacityProvider) : this() {
            this.autoScalingGroupProvider = x.autoScalingGroupProvider
            this.capacityProviderArn = x.capacityProviderArn
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
            this.updateStatus = x.updateStatus
            this.updateStatusReason = x.updateStatusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.CapacityProvider = CapacityProvider(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider] inside the given [block]
         */
        public fun autoScalingGroupProvider(block: aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider.Builder.() -> kotlin.Unit) {
            this.autoScalingGroupProvider = aws.sdk.kotlin.services.ecs.model.AutoScalingGroupProvider.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
