// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.serde

import aws.sdk.kotlin.services.ecs.model.Cluster
import aws.sdk.kotlin.services.ecs.model.DeleteClusterResponse
import aws.sdk.kotlin.services.ecs.model.EcsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteClusterOperationDeserializer: HttpDeserialize<DeleteClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteClusterError(context, call)
        }
        val builder = DeleteClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EcsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterContainsServicesException" -> ClusterContainsServicesExceptionDeserializer().deserialize(context, wrappedCall)
        "ClusterNotFoundException" -> ClusterNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ClusterContainsTasksException" -> ClusterContainsTasksExceptionDeserializer().deserialize(context, wrappedCall)
        "ServerException" -> ServerExceptionDeserializer().deserialize(context, wrappedCall)
        "UpdateInProgressException" -> UpdateInProgressExceptionDeserializer().deserialize(context, wrappedCall)
        "ClusterContainsContainerInstancesException" -> ClusterContainsContainerInstancesExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientException" -> ClientExceptionDeserializer().deserialize(context, wrappedCall)
        else -> EcsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteClusterOperationBody(builder: DeleteClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTER_DESCRIPTOR.index -> builder.cluster = deserializeClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
