// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



public class UpdateClusterRequest private constructor(builder: Builder) {
    /**
     * The name of the cluster to modify the settings for.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The execute command configuration for the cluster.
     */
    public val configuration: aws.sdk.kotlin.services.ecs.model.ClusterConfiguration? = builder.configuration
    /**
     * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the `enabled` parameter to `true` in the `ServiceConnectConfiguration`. You can set the namespace of each service individually in the `ServiceConnectConfiguration` to override this default parameter.
     *
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val serviceConnectDefaults: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaultsRequest? = builder.serviceConnectDefaults
    /**
     * The cluster settings for your cluster.
     */
    public val settings: List<ClusterSetting>? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.UpdateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClusterRequest(")
        append("cluster=$cluster,")
        append("configuration=$configuration,")
        append("serviceConnectDefaults=$serviceConnectDefaults,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cluster?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (serviceConnectDefaults?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClusterRequest

        if (cluster != other.cluster) return false
        if (configuration != other.configuration) return false
        if (serviceConnectDefaults != other.serviceConnectDefaults) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.UpdateClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the cluster to modify the settings for.
         */
        public var cluster: kotlin.String? = null
        /**
         * The execute command configuration for the cluster.
         */
        public var configuration: aws.sdk.kotlin.services.ecs.model.ClusterConfiguration? = null
        /**
         * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the `enabled` parameter to `true` in the `ServiceConnectConfiguration`. You can set the namespace of each service individually in the `ServiceConnectConfiguration` to override this default parameter.
         *
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var serviceConnectDefaults: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaultsRequest? = null
        /**
         * The cluster settings for your cluster.
         */
        public var settings: List<ClusterSetting>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.UpdateClusterRequest) : this() {
            this.cluster = x.cluster
            this.configuration = x.configuration
            this.serviceConnectDefaults = x.serviceConnectDefaults
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.UpdateClusterRequest = UpdateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ClusterConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.ecs.model.ClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.ecs.model.ClusterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaultsRequest] inside the given [block]
         */
        public fun serviceConnectDefaults(block: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaultsRequest.Builder.() -> kotlin.Unit) {
            this.serviceConnectDefaults = aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaultsRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
