// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The termination policy for the Amazon EBS volume when the task exits. For more information, see [Amazon ECS volume termination policy](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types).
 */
public class TaskManagedEbsVolumeTerminationPolicy private constructor(builder: Builder) {
    /**
     * Indicates whether the volume should be deleted on when the task stops. If a value of `true` is specified,  Amazon ECS deletes the Amazon EBS volume on your behalf when the task goes into the `STOPPED` state. If no value is specified, the  default value is `true` is used. When set to `false`, Amazon ECS leaves the volume in your  account.
     */
    public val deleteOnTermination: kotlin.Boolean = requireNotNull(builder.deleteOnTermination) { "A non-null value must be provided for deleteOnTermination" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskManagedEbsVolumeTerminationPolicy(")
        append("deleteOnTermination=$deleteOnTermination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskManagedEbsVolumeTerminationPolicy

        if (deleteOnTermination != other.deleteOnTermination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the volume should be deleted on when the task stops. If a value of `true` is specified,  Amazon ECS deletes the Amazon EBS volume on your behalf when the task goes into the `STOPPED` state. If no value is specified, the  default value is `true` is used. When set to `false`, Amazon ECS leaves the volume in your  account.
         */
        public var deleteOnTermination: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy) : this() {
            this.deleteOnTermination = x.deleteOnTermination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.TaskManagedEbsVolumeTerminationPolicy = TaskManagedEbsVolumeTerminationPolicy(this)

        internal fun correctErrors(): Builder {
            if (deleteOnTermination == null) deleteOnTermination = false
            return this
        }
    }
}
