// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value. You define them.
 *
 * The following basic restrictions apply to tags:
 * + Maximum number of tags per resource - 50
 * + For each resource, each tag key must be unique, and each tag key can have only one value.
 * + Maximum key length - 128 Unicode characters in UTF-8
 * + Maximum value length - 256 Unicode characters in UTF-8
 * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
 * + Tag keys and values are case-sensitive.
 * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
 */
public class Tag private constructor(builder: Builder) {
    /**
     * One part of a key-value pair that make up a tag. A `key` is a general label that acts like a category for more specific tag values.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The optional part of a key-value pair that make up a tag. A `value` acts as a descriptor within a tag category (key).
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Tag = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One part of a key-value pair that make up a tag. A `key` is a general label that acts like a category for more specific tag values.
         */
        public var key: kotlin.String? = null
        /**
         * The optional part of a key-value pair that make up a tag. A `value` acts as a descriptor within a tag category (key).
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Tag = Tag(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
