// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * The Service Connect resource. Each configuration maps a discovery name to a Cloud Map service name. The data is stored in Cloud Map as part of the Service Connect configuration for each discovery name of this Amazon ECS service.
 *
 * A task can resolve the `dnsName` for each of the `clientAliases` of a service. However a task can't resolve the discovery names. If you want to connect to a service, refer to the `ServiceConnectConfiguration` of that service for the list of `clientAliases` that you can use.
 */
public class ServiceConnectServiceResource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the namespace in Cloud Map that matches the discovery name for this Service Connect resource. You can use this ARN in other integrations with Cloud Map. However, Service Connect can't ensure connectivity outside of Amazon ECS.
     */
    public val discoveryArn: kotlin.String? = builder.discoveryArn
    /**
     * The discovery name of this Service Connect resource.
     *
     * The `discoveryName` is the name of the new Cloud Map service that Amazon ECS creates for this Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
     *
     * If the `discoveryName` isn't specified, the port mapping name from the task definition is used in `portName.namespace`.
     */
    public val discoveryName: kotlin.String? = builder.discoveryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ServiceConnectServiceResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceConnectServiceResource(")
        append("discoveryArn=$discoveryArn,")
        append("discoveryName=$discoveryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = discoveryArn?.hashCode() ?: 0
        result = 31 * result + (discoveryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceConnectServiceResource

        if (discoveryArn != other.discoveryArn) return false
        if (discoveryName != other.discoveryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ServiceConnectServiceResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the namespace in Cloud Map that matches the discovery name for this Service Connect resource. You can use this ARN in other integrations with Cloud Map. However, Service Connect can't ensure connectivity outside of Amazon ECS.
         */
        public var discoveryArn: kotlin.String? = null
        /**
         * The discovery name of this Service Connect resource.
         *
         * The `discoveryName` is the name of the new Cloud Map service that Amazon ECS creates for this Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
         *
         * If the `discoveryName` isn't specified, the port mapping name from the task definition is used in `portName.namespace`.
         */
        public var discoveryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ServiceConnectServiceResource) : this() {
            this.discoveryArn = x.discoveryArn
            this.discoveryName = x.discoveryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ServiceConnectServiceResource = ServiceConnectServiceResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
