// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * Each alias ("endpoint") is a fully-qualified name and port number that other tasks ("clients") can use to connect to this service.
 *
 * Each name and port mapping must be unique within the namespace.
 *
 * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class ServiceConnectClientAlias private constructor(builder: Builder) {
    /**
     * The `dnsName` is the name that you use in the applications of client tasks to connect to this service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The name can't start with a hyphen.
     *
     * If this parameter isn't specified, the default value of `discoveryName.namespace` is used. If the `discoveryName` isn't specified, the port mapping name from the task definition is used in `portName.namespace`.
     *
     * To avoid changing your applications in client Amazon ECS services, set this to the same name that the client application uses by default. For example, a few common names are `database`, `db`, or the lowercase name of a database, such as `mysql` or `redis`. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
     *
     * To avoid changing your applications in client Amazon ECS services, set this to the same port that the client application uses by default. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val port: kotlin.Int = requireNotNull(builder.port) { "A non-null value must be provided for port" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ServiceConnectClientAlias = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceConnectClientAlias(")
        append("dnsName=$dnsName,")
        append("port=$port")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsName?.hashCode() ?: 0
        result = 31 * result + (port)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceConnectClientAlias

        if (dnsName != other.dnsName) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ServiceConnectClientAlias = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `dnsName` is the name that you use in the applications of client tasks to connect to this service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The name can't start with a hyphen.
         *
         * If this parameter isn't specified, the default value of `discoveryName.namespace` is used. If the `discoveryName` isn't specified, the port mapping name from the task definition is used in `portName.namespace`.
         *
         * To avoid changing your applications in client Amazon ECS services, set this to the same name that the client application uses by default. For example, a few common names are `database`, `db`, or the lowercase name of a database, such as `mysql` or `redis`. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
         *
         * To avoid changing your applications in client Amazon ECS services, set this to the same port that the client application uses by default. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var port: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ServiceConnectClientAlias) : this() {
            this.dnsName = x.dnsName
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ServiceConnectClientAlias = ServiceConnectClientAlias(this)

        internal fun correctErrors(): Builder {
            if (port == null) port = 0
            return this
        }
    }
}
