// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model



/**
 * An object representing the secret to expose to your container. Secrets can be exposed to a container in the following ways:
 * + To inject sensitive data into your containers as environment variables, use the `secrets` container definition parameter.
 * + To reference sensitive information in the log configuration of a container, use the `secretOptions` container definition parameter.
 *
 * For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
 */
public class Secret private constructor(builder: Builder) {
    /**
     * The name of the secret.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The secret to expose to the container. The supported values are either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
     *
     * For information about the require Identity and Access Management permissions, see [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam) (for Secrets Manager) or [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html) (for Systems Manager Parameter store) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
     */
    public val valueFrom: kotlin.String = requireNotNull(builder.valueFrom) { "A non-null value must be provided for valueFrom" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Secret = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Secret(")
        append("name=$name,")
        append("valueFrom=$valueFrom")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (valueFrom.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Secret

        if (name != other.name) return false
        if (valueFrom != other.valueFrom) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Secret = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the secret.
         */
        public var name: kotlin.String? = null
        /**
         * The secret to expose to the container. The supported values are either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
         *
         * For information about the require Identity and Access Management permissions, see [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam) (for Secrets Manager) or [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html) (for Systems Manager Parameter store) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         */
        public var valueFrom: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Secret) : this() {
            this.name = x.name
            this.valueFrom = x.valueFrom
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Secret = Secret(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (valueFrom == null) valueFrom = ""
            return this
        }
    }
}
